/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.tools.DateTools;
import com.x.server.console.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Shadow {
    private static final String MANIFEST_FILENAME = "manifest.cfg";
    private static boolean tag = true;

    public static void main(String[] args) throws Exception {
        String base = Shadow.getBasePath();
        Shadow.loadJars(base);
        tag = true;
        final File logFile = new File(Config.base(), "logs/" + DateTools.format((Date)new Date(), (String)"yyyy_MM_dd") + ".out.log");
        if (!logFile.exists()) {
            System.out.println("can not find log file,server not running.");
        } else {
            new Thread(){

                @Override
                public void run() {
                    try (FileReader fr = new FileReader(logFile);
                         BufferedReader br = new BufferedReader(fr);){
                        System.out.println("console start, type close to exit console.");
                        br.skip(logFile.length());
                        String line = null;
                        while (tag) {
                            line = br.readLine();
                            if (line != null) {
                                System.out.println(line);
                                continue;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                String cmd = "";
                while (tag) {
                    cmd = reader.readLine();
                    if (null == cmd || StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)StringUtils.trim((String)cmd))) {
                        tag = false;
                        System.exit(0);
                    }
                    RandomAccessFile raf = new RandomAccessFile(Shadow.getBasePath() + "/command.swap", "rw");
                    Throwable throwable = null;
                    try {
                        FileChannel fc = raf.getChannel();
                        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, 256L);
                        FileLock flock = null;
                        flock = fc.lock();
                        mbb.put(cmd.getBytes());
                        flock.release();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (raf == null) continue;
                        if (throwable != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        raf.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadJars(String base) throws Exception {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        File extDir = new File(base, "commons/ext");
        File extDirManifest = new File(extDir, MANIFEST_FILENAME);
        if (!extDirManifest.exists()) {
            throw new Exception("can not find manifest.cfg in commons/ext.");
        }
        List<String> extDirManifestNames = Shadow.readManifest(extDirManifest);
        if (extDirManifestNames.isEmpty()) {
            throw new Exception("commons/ext manifest is empty.");
        }
        for (File file : extDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME)) continue;
            if (!extDirManifestNames.contains(file.getName())) {
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        File jarsDir = new File(base, "store/jars");
        File jarsDirManifest = new File(jarsDir, MANIFEST_FILENAME);
        if (!jarsDirManifest.exists()) {
            throw new Exception("can not find manifest.cfg in store/jars.");
        }
        List<String> jarsDirManifestNames = Shadow.readManifest(jarsDirManifest);
        for (File file : jarsDir.listFiles()) {
            if (file.getName().equals(MANIFEST_FILENAME)) continue;
            if (!jarsDirManifestNames.contains(file.getName())) {
                file.delete();
                continue;
            }
            method.invoke((Object)urlClassLoader, file.toURI().toURL());
        }
        File file = new File(base, "local/temp/classes");
        method.invoke((Object)urlClassLoader, file.toURI().toURL());
    }

    private static String getBasePath() throws Exception {
        String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File file = new File(path);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (null != file) {
            File versionFile = new File(file, "version.o2");
            if (versionFile.exists()) {
                return file.getAbsolutePath();
            }
            file = file.getParentFile();
        }
        throw new Exception("can not define o2server base directory.");
    }

    private static List<String> readManifest(File file) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }
}

