/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.x.base.core.entity.StorageObject;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataMapping;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.config.StorageMapping;
import com.x.base.core.project.config.StorageMappings;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.action.DumpRestoreStorageCatalog;
import com.x.server.console.action.DumpRestoreStorageCatalogItem;
import com.x.server.console.action.PersistenceXmlHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class ActionDumpStorage {
    private static Logger logger = LoggerFactory.getLogger(ActionDumpStorage.class);
    private Date start;
    private File dir;
    private DumpRestoreStorageCatalog catalog;
    private Gson pureGsonDateFormated;

    private void init() throws Exception {
        this.start = new Date();
        this.dir = new File(Config.base(), "local/dump/dumpStorage_" + DateTools.compact((Date)this.start));
        this.pureGsonDateFormated = XGsonBuilder.instance();
        this.catalog = new DumpRestoreStorageCatalog();
        FileUtils.forceMkdir((File)this.dir);
        FileUtils.cleanDirectory((File)this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String password) throws Exception {
        this.init();
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not match.", new Object[0]);
            return false;
        }
        List<Class<?>> classes = PersistenceXmlHelper.listClassWithIncludesExcludes(PersistenceXmlHelper.listStorageClassName(), Config.dumpRestoreStorage().getIncludes(), Config.dumpRestoreStorage().getExcludes());
        DataMappings dataMappings = Config.dataMappings();
        StorageMappings storageMappings = Config.storageMappings();
        logger.print("dump storage find {} data to dump, start at {}.", new Object[]{classes.size(), DateTools.format((Date)this.start)});
        for (int i = 0; i < classes.size(); ++i) {
            Class<?> cls = classes.get(i);
            List sources = (List)dataMappings.get((Object)cls.getName());
            if (ListTools.isEmpty((List[])new List[]{sources})) {
                throw new Exception("can not get datamapping of class:" + cls.getName() + ".");
            }
            OpenJPAEntityManagerFactory emf = OpenJPAPersistence.createEntityManagerFactory((String)cls.getName(), (String)this.createPersistenceXml(cls, sources).getName());
            EntityManager em = emf.createEntityManager();
            try {
                logger.print("dump storage({}/{}): {}, estimate count: {}, estimate size: {}M.", new Object[]{i + 1, classes.size(), cls.getName(), this.estimateCount(em, cls), this.estimateSize(em, cls) / 1024L / 1024L});
                this.dump(cls, em, storageMappings);
                continue;
            }
            finally {
                em.close();
                emf.close();
            }
        }
        FileUtils.write((File)new File(this.dir, "catalog.json"), (CharSequence)XGsonBuilder.instance().toJson((Object)this.catalog), (Charset)DefaultCharset.charset);
        logger.print("dump storage completed, directory: {}, count: {}, normal: {}, empty: {}, invalidStorage: {}, size: {}M, elapsed: {} minutes.", new Object[]{this.dir.getAbsolutePath(), this.count(), this.normal(), this.empty(), this.invalidStorage(), this.size() / 1024L / 1024L, (new Date().getTime() - this.start.getTime()) / 1000L / 60L});
        return true;
    }

    private Integer count() {
        return this.catalog.values().stream().mapToInt(DumpRestoreStorageCatalogItem::getCount).sum();
    }

    private Long size() {
        return this.catalog.values().stream().mapToLong(DumpRestoreStorageCatalogItem::getSize).sum();
    }

    private Long normal() {
        return this.catalog.values().stream().mapToLong(DumpRestoreStorageCatalogItem::getNormal).sum();
    }

    private Long empty() {
        return this.catalog.values().stream().mapToLong(DumpRestoreStorageCatalogItem::getEmpty).sum();
    }

    private Long invalidStorage() {
        return this.catalog.values().stream().mapToLong(DumpRestoreStorageCatalogItem::getInvalidStorage).sum();
    }

    private <T> File createPersistenceXml(Class<T> cls, List<DataMapping> sources) throws Exception {
        File xml = new File(this.dir, cls.getName() + "_dump.xml");
        PersistenceXmlHelper.createPersistenceXml(cls, sources, xml);
        File tempFile = File.createTempFile(DateTools.compact((Date)this.start), ".xml", new File(Config.base(), "local/temp/classes"));
        FileUtils.copyFile((File)xml, (File)tempFile);
        return tempFile;
    }

    private <T> long estimateCount(EntityManager em, Class<T> cls) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(cls);
        cq.select((Selection)cb.count((Expression)root));
        return (Long)em.createQuery(cq).getSingleResult();
    }

    private <T> long estimateSize(EntityManager em, Class<T> cls) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(cls);
        cq.select((Selection)root.get("length"));
        List list = em.createQuery(cq).getResultList();
        if (!list.isEmpty()) {
            return list.stream().filter(o -> null != o).mapToLong(Long::longValue).sum();
        }
        return 0L;
    }

    private <T extends StorageObject> void dump(Class<T> cls, EntityManager em, StorageMappings storageMappings) throws Exception {
        File classDirectory = new File(this.dir, cls.getName());
        FileUtils.forceMkdir((File)classDirectory);
        FileUtils.cleanDirectory((File)classDirectory);
        int count = 0;
        long size = 0L;
        int normal = 0;
        int invalidStorage = 0;
        int empty = 0;
        String id = "";
        String name = "";
        List<T> list = null;
        File directory = null;
        StorageMapping mapping = null;
        ArrayList<StorageObject> normalList = null;
        ArrayList<StorageObject> emptyList = null;
        ArrayList<StorageObject> invalidStorageList = null;
        do {
            if (ListTools.isNotEmpty((List[])new List[]{list = this.list(em, cls, id, Config.dumpRestoreStorage().getBatchSize())})) {
                directory = new File(classDirectory, Integer.toString(count += list.size()));
                FileUtils.forceMkdir((File)directory);
                FileUtils.cleanDirectory((File)directory);
                normalList = new ArrayList<StorageObject>();
                emptyList = new ArrayList<StorageObject>();
                invalidStorageList = new ArrayList<StorageObject>();
                for (StorageObject t : list) {
                    name = t.getStorage();
                    mapping = storageMappings.get(cls, name);
                    if (null == mapping && Config.dumpRestoreStorage().getExceptionInvalidStorage().booleanValue()) {
                        throw new Exception("can not find storageMapping class: " + cls.getName() + ", storage: " + name + ", id: " + t.getId() + ", name: " + t.getName() + ", set exceptionInvalidStorage to false will ignore item.");
                    }
                    if (null != mapping) {
                        File file = new File(directory, FilenameUtils.getName((String)t.path()));
                        if (t.existContent(mapping)) {
                            FileOutputStream fos = new FileOutputStream(file);
                            Throwable throwable = null;
                            try {
                                size += t.readContent(mapping, (OutputStream)fos).longValue();
                                normalList.add(t);
                                ++normal;
                                continue;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                fos.close();
                                continue;
                            }
                        }
                        emptyList.add(t);
                        ++empty;
                        continue;
                    }
                    invalidStorageList.add(t);
                    ++invalidStorage;
                }
                id = BeanUtils.getProperty(list.get(list.size() - 1), (String)"id");
                File file = new File(classDirectory, count + ".json");
                this.dumpWrite(file, normalList, emptyList, invalidStorageList);
            }
            em.clear();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
        DumpRestoreStorageCatalogItem item = new DumpRestoreStorageCatalogItem();
        item.setCount(count);
        item.setNormal(normal);
        item.setEmpty(empty);
        item.setSize(size);
        item.setInvalidStorage(invalidStorage);
        this.catalog.put(cls.getName(), item);
        System.out.println("dumped storage: " + cls.getName() + ", count: " + count + ", normal: " + normal + ", invalidStorage: " + invalidStorage + ", empty: " + empty + ", size: " + size / 1024L / 1024L + "M.");
    }

    private <T extends StorageObject> void dumpWrite(File file, List<T> normalList, List<T> emptyList, List<T> invalidStorageList) throws Exception {
        LinkedHashMap<String, List<T>> o = new LinkedHashMap<String, List<T>>();
        o.put("normals", normalList);
        o.put("emptys", emptyList);
        o.put("invalidStorages", invalidStorageList);
        FileUtils.write((File)file, (CharSequence)this.pureGsonDateFormated.toJson(o), (Charset)DefaultCharset.charset);
    }

    private <T extends StorageObject> List<T> list(EntityManager em, Class<T> cls, String id, Integer size) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(cls);
        Root root = cq.from(cls);
        Predicate p = cb.conjunction();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            p = cb.greaterThan((Expression)root.get("id"), (Comparable)((Object)id));
        }
        cq.select((Selection)root).where((Expression)p).orderBy(new Order[]{cb.asc((Expression)root.get("id"))});
        return em.createQuery(cq).setMaxResults(size.intValue()).getResultList();
    }
}

