/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataMapping;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.BaseTools;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.action.DumpRestoreDataCatalog;
import com.x.server.console.action.PersistenceXmlHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class ActionRestoreData {
    private static Logger logger = LoggerFactory.getLogger(ActionRestoreData.class);
    private Date start;
    private File dir;
    private DumpRestoreDataCatalog catalog;
    private Gson pureGsonDateFormated;

    private void init(Date date) throws Exception {
        this.start = new Date();
        this.dir = new File(Config.base(), "local/dump/dumpData_" + DateTools.compact((Date)date));
        this.catalog = (DumpRestoreDataCatalog)BaseTools.readObject((String)("local/dump/dumpData_" + DateTools.compact((Date)date) + "/catalog.json"), DumpRestoreDataCatalog.class);
        this.pureGsonDateFormated = XGsonBuilder.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Date date, String password) throws Exception {
        this.init(date);
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not mactch.", new Object[0]);
            return false;
        }
        List<Class<?>> classes = PersistenceXmlHelper.listClassWithIncludesExcludes(new ArrayList<String>(this.catalog.keySet()), Config.dumpRestoreData().getIncludes(), Config.dumpRestoreData().getExcludes());
        logger.print("find: {} data to restore, dump time: {}.", new Object[]{classes.size(), DateTools.format((Date)date)});
        DataMappings mappings = Config.dataMappings();
        long count = 0L;
        for (int i = 0; i < classes.size(); ++i) {
            Class<?> cls = classes.get(i);
            List sources = (List)mappings.get((Object)cls.getName());
            if (ListTools.isEmpty((List[])new List[]{sources})) {
                throw new Exception("can not get datamapping of class:" + cls.getName() + ".");
            }
            OpenJPAEntityManagerFactory emf = OpenJPAPersistence.createEntityManagerFactory((String)cls.getName(), (String)this.createPersistenceXml(cls, sources).getName());
            EntityManager em = emf.createEntityManager();
            em.setFlushMode(FlushModeType.COMMIT);
            try {
                logger.print("restore data({}/{}): {}, count: {}.", new Object[]{i + 1, classes.size(), cls.getName(), this.catalog.get(cls.getName())});
                count += this.store(cls, em);
                continue;
            }
            finally {
                em.close();
                emf.close();
            }
        }
        logger.print("restore data completed, total count: {}, elapsed: {} minutes.", new Object[]{count, (new Date().getTime() - this.start.getTime()) / 1000L / 60L});
        return true;
    }

    private <T> File createPersistenceXml(Class<T> cls, List<DataMapping> sources) throws Exception {
        File xml = new File(this.dir, cls.getName() + "_restore.xml");
        PersistenceXmlHelper.createPersistenceXml(cls, sources, xml);
        File tempFile = File.createTempFile(DateTools.compact((Date)this.start), ".xml", new File(Config.base(), "local/temp/classes"));
        FileUtils.copyFile((File)xml, (File)tempFile);
        return tempFile;
    }

    private <T> long store(Class<T> cls, EntityManager em) throws Exception {
        File directory = new File(this.dir, cls.getName());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new Exception("can not find directory: " + directory.getAbsolutePath() + ".");
        }
        long count = 0L;
        ArrayList files = new ArrayList(FileUtils.listFiles((File)directory, (String[])new String[]{"json"}, (boolean)false));
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String n1 = FilenameUtils.getBaseName((String)o1.getName());
                String n2 = FilenameUtils.getBaseName((String)o2.getName());
                Integer i1 = Integer.parseInt(n1);
                Integer i2 = Integer.parseInt(n2);
                return i1.compareTo(i2);
            }
        });
        this.clean(cls, em);
        File file = null;
        for (int i = 0; i < files.size(); ++i) {
            file = (File)files.get(i);
            System.out.println("restoring " + (i + 1) + "/" + files.size() + " part of data: " + cls.getName() + ".");
            JsonArray raws = this.convert(file);
            em.getTransaction().begin();
            for (JsonElement o : raws) {
                Object t = this.pureGsonDateFormated.fromJson(o, cls);
                em.persist(t);
                ++count;
            }
            em.getTransaction().commit();
            em.clear();
        }
        System.out.println("restore data: " + cls.getName() + " completed, count: " + count + ".");
        return count;
    }

    private JsonArray convert(File file) throws Exception {
        String json = FileUtils.readFileToString((File)file, (Charset)DefaultCharset.charset);
        JsonElement jsonElement = (JsonElement)this.pureGsonDateFormated.fromJson(json, JsonElement.class);
        return jsonElement.getAsJsonArray();
    }

    private <T> void clean(Class<T> cls, EntityManager em) throws Exception {
        List list = null;
        do {
            if (ListTools.isNotEmpty((List[])new List[]{list})) {
                em.getTransaction().begin();
                for (Object t : list) {
                    em.remove(t);
                }
                em.getTransaction().commit();
            }
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(cls);
            Root root = cq.from(cls);
            cq.select((Selection)root);
            list = em.createQuery(cq).setMaxResults(Config.dumpRestoreData().getBatchSize().intValue()).getResultList();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
    }
}

