/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataServer;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.server.console.action.ActionBase;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.Driver;
import org.h2.tools.RunScript;

public class ActionSetPassword
extends ActionBase {
    private static Logger logger = LoggerFactory.getLogger(ActionSetPassword.class);

    public boolean execute(String oldPassword, String newPassword) throws Exception {
        if (StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)"o2")) {
            oldPassword = "o2";
        }
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)oldPassword)) {
            logger.print("old password not match.", new Object[0]);
            return false;
        }
        this.changeInternalDataServerPassword(oldPassword, newPassword);
        Config.token().setPassword(newPassword);
        Config.token().save();
        logger.print("The initial manager password has been modified.", new Object[0]);
        return true;
    }

    private void changeInternalDataServerPassword(String oldPassword, String newPassword) throws Exception {
        Driver.load();
        for (Map.Entry en : Config.nodes().dataServers().entrySet()) {
            DataServer o = (DataServer)en.getValue();
            if (!BooleanUtils.isTrue((Boolean)o.getEnable())) continue;
            try {
                Connection conn = DriverManager.getConnection("jdbc:h2:tcp://" + (String)en.getKey() + ":" + o.getTcpPort() + "/X", "sa", oldPassword);
                Throwable throwable = null;
                try {
                    RunScript.execute((Connection)conn, (Reader)new StringReader("ALTER USER SA SET PASSWORD '" + newPassword + "'"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conn == null) continue;
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    conn.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Verify that the dataServer:" + (String)en.getKey() + " is started and that the dataServer password is updated synchronously.", e);
            }
        }
    }
}

