/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.action.ActionBase;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class ActionVersion
extends ActionBase {
    private static Logger logger = LoggerFactory.getLogger(ActionVersion.class);

    public void execute() throws Exception {
        List<WrapVersion> wos = this.list();
        if (ListTools.isEmpty((List[])new List[]{wos})) {
            System.out.println("already the latest version!");
        } else {
            for (WrapVersion _o : wos) {
                System.out.println("version:" + _o.getVersion() + ", size:" + _o.getSize() / 1024L / 1024L + "M");
                for (String _s : _o.getDescriptionList()) {
                    System.out.println(_s);
                }
            }
        }
    }

    List<WrapVersion> list() throws Exception {
        JsonObject jsonObject;
        List<Object> wos = new ArrayList();
        String address = Config.collect().url("/o2_collect_assemble/jaxrs/update/list/next/" + Config.version());
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setRequestMethod("GET");
        connection.setDoOutput(false);
        connection.setDoInput(true);
        connection.connect();
        String json = "";
        try (InputStream input = connection.getInputStream();){
            json = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
        connection.disconnect();
        Gson gson = XGsonBuilder.instance();
        JsonElement jsonElement = (JsonElement)gson.fromJson(json, JsonElement.class);
        if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has("data")) {
            wos = (List)gson.fromJson(jsonObject.get("data"), new TypeToken<List<WrapVersion>>(){}.getType());
        }
        wos = wos.stream().sorted(Comparator.comparing(WrapVersion::getVersion)).collect(Collectors.toList());
        return wos;
    }

    public static class WrapVersion {
        private List<String> descriptionList = new ArrayList<String>();
        private String version;
        private Long size;

        public List<String> getDescriptionList() {
            return this.descriptionList;
        }

        public void setDescriptionList(List<String> descriptionList) {
            this.descriptionList = descriptionList;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }
}

