/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.action;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.x.base.core.entity.StorageObject;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.DataMapping;
import com.x.base.core.project.config.DataMappings;
import com.x.base.core.project.config.StorageMapping;
import com.x.base.core.project.config.StorageMappings;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.BaseTools;
import com.x.base.core.project.tools.DateTools;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.ListTools;
import com.x.server.console.action.DumpRestoreStorageCatalog;
import com.x.server.console.action.DumpRestoreStorageCatalogItem;
import com.x.server.console.action.PersistenceXmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class ActionRestoreStorage {
    private static Logger logger = LoggerFactory.getLogger(ActionRestoreStorage.class);
    private Date start;
    private File dir;
    private DumpRestoreStorageCatalog catalog;
    private Gson pureGsonDateFormated;

    private void init(Date date) throws Exception {
        this.start = new Date();
        this.dir = new File(Config.base(), "local/dump/dumpStorage_" + DateTools.compact((Date)date));
        this.catalog = (DumpRestoreStorageCatalog)BaseTools.readObject((String)("local/dump/dumpStorage_" + DateTools.compact((Date)date) + "/catalog.json"), DumpRestoreStorageCatalog.class);
        this.pureGsonDateFormated = XGsonBuilder.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Date date, String password) throws Exception {
        this.init(date);
        if (!StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)password)) {
            logger.print("password not mactch.", new Object[0]);
            return false;
        }
        List<Class<?>> classes = PersistenceXmlHelper.listClassWithIncludesExcludes(new ArrayList<String>(this.catalog.keySet()), Config.dumpRestoreStorage().getIncludes(), Config.dumpRestoreStorage().getExcludes());
        logger.print("restore storage find {} to restore.", new Object[]{classes.size()});
        DataMappings mappings = Config.dataMappings();
        StorageMappings storageMappings = Config.storageMappings();
        int count = 0;
        for (int i = 0; i < classes.size(); ++i) {
            Class<?> cls = classes.get(i);
            List sources = (List)mappings.get((Object)cls.getName());
            if (ListTools.isEmpty((List[])new List[]{sources})) {
                throw new Exception("can not get datamapping of class:" + cls.getName() + ".");
            }
            OpenJPAEntityManagerFactory emf = OpenJPAPersistence.createEntityManagerFactory((String)cls.getName(), (String)this.createPersistenceXml(cls, sources).getName());
            EntityManager em = emf.createEntityManager();
            em.setFlushMode(FlushModeType.COMMIT);
            try {
                DumpRestoreStorageCatalogItem item = (DumpRestoreStorageCatalogItem)((Object)this.catalog.get(cls.getName()));
                logger.print("restore storage({}/{}): {}, count: {}, normal: {} will be restore, invalidStorage: {} and empty: {} will be ignore, size: {}M.", new Object[]{i + 1, classes.size(), cls.getName(), item.getCount(), item.getNormal(), item.getInvalidStorage(), item.getEmpty(), item.getSize() / 1024L / 1024L});
                count = (int)((long)count + this.store(cls, em, storageMappings));
            }
            finally {
                em.close();
                emf.close();
            }
            logger.print("restore storage completed, total count: {}, elapsed: {} minutes.", new Object[]{count, (new Date().getTime() - this.start.getTime()) / 1000L / 60L});
        }
        return false;
    }

    private <T> File createPersistenceXml(Class<T> cls, List<DataMapping> sources) throws Exception {
        File xml = new File(this.dir, cls.getName() + "_dump.xml");
        PersistenceXmlHelper.createPersistenceXml(cls, sources, xml);
        File tempFile = File.createTempFile(DateTools.compact((Date)this.start), ".xml", new File(Config.base(), "local/temp/classes"));
        FileUtils.copyFile((File)xml, (File)tempFile);
        return tempFile;
    }

    private <T extends StorageObject> long store(Class<T> cls, EntityManager em, StorageMappings storageMappings) throws Exception {
        File classDirectory = new File(this.dir, cls.getName());
        if (!classDirectory.exists() || !classDirectory.isDirectory()) {
            throw new Exception("can not find directory: " + classDirectory.getAbsolutePath() + ".");
        }
        long count = 0L;
        ArrayList files = new ArrayList(FileUtils.listFiles((File)classDirectory, (String[])new String[]{"json"}, (boolean)false));
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String n1 = FilenameUtils.getBaseName((String)o1.getName());
                String n2 = FilenameUtils.getBaseName((String)o2.getName());
                Integer i1 = Integer.parseInt(n1);
                Integer i2 = Integer.parseInt(n2);
                return i1.compareTo(i2);
            }
        });
        this.clean(cls, em, storageMappings);
        StorageMapping mapping = null;
        File file = null;
        for (int i = 0; i < files.size(); ++i) {
            file = (File)files.get(i);
            logger.print("restoring " + (i + 1) + "/" + files.size() + " part of storage: " + cls.getName() + ".", new Object[0]);
            JsonArray raws = this.convert(file);
            if (null == raws) continue;
            em.getTransaction().begin();
            for (JsonElement o : raws) {
                StorageObject t = (StorageObject)this.pureGsonDateFormated.fromJson(o, cls);
                mapping = Config.dumpRestoreStorage().getRedistribute() != false ? storageMappings.random(cls) : storageMappings.get(cls, t.getStorage());
                if (null == mapping) {
                    throw new Exception("can not find storageMapping class: " + cls.getName() + ", name:" + t.getName());
                }
                File source = new File(classDirectory, FilenameUtils.getBaseName((String)file.getName()) + "/" + FilenameUtils.getName((String)t.path()));
                try (FileInputStream input = new FileInputStream(source);){
                    t.saveContent(mapping, (InputStream)input, t.getName());
                }
                em.persist((Object)t);
                ++count;
            }
            em.getTransaction().commit();
            em.clear();
        }
        return count;
    }

    private JsonArray convert(File file) throws Exception {
        String json = FileUtils.readFileToString((File)file, (Charset)DefaultCharset.charset);
        JsonElement jsonElement = (JsonElement)this.pureGsonDateFormated.fromJson(json, JsonElement.class);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return jsonObject.get("normals").getAsJsonArray();
    }

    private <T extends StorageObject> void clean(Class<T> cls, EntityManager em, StorageMappings storageMappings) throws Exception {
        List list = null;
        StorageMapping mapping = null;
        do {
            if (ListTools.isNotEmpty((List[])new List[]{list})) {
                em.getTransaction().begin();
                for (StorageObject t : list) {
                    mapping = storageMappings.get(cls, t.getStorage());
                    if (null != mapping) {
                        t.deleteContent(mapping);
                    }
                    em.remove((Object)t);
                }
                em.getTransaction().commit();
            }
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(cls);
            Root root = cq.from(cls);
            cq.select((Selection)root);
            list = em.createQuery(cq).setMaxResults(Config.dumpRestoreData().getBatchSize().intValue()).getResultList();
        } while (ListTools.isNotEmpty((List[])new List[]{list}));
    }
}

