/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.tools.DefaultCharset;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class JettySeverTools {
    protected static void addHttpsConnector(Server server, Integer port) throws Exception {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(Config.sslKeyStore().getAbsolutePath());
        sslContextFactory.setKeyStorePassword(Config.token().getSslKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(Config.token().getSslKeyManagerPassword());
        sslContextFactory.setTrustAll(true);
        HttpConfiguration config = new HttpConfiguration();
        config.setSecureScheme("https");
        config.setOutputBufferSize(32768);
        config.setRequestHeaderSize(8192);
        config.setResponseHeaderSize(8192);
        config.setSendServerVersion(true);
        config.setSendDateHeader(false);
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(config)});
        sslConnector.setPort(port.intValue());
        server.addConnector((Connector)sslConnector);
    }

    protected static void addHttpConnector(Server server, Integer port) throws Exception {
        HttpConfiguration config = new HttpConfiguration();
        config.setOutputBufferSize(32768);
        config.setRequestHeaderSize(8192);
        config.setResponseHeaderSize(8192);
        config.setSendServerVersion(true);
        config.setSendDateHeader(false);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        http.setIdleTimeout(30000L);
        http.setPort(port.intValue());
        server.addConnector((Connector)http);
    }

    protected static void cleanDirectory(File dir) throws Exception {
        FileUtils.forceMkdir((File)dir);
        FileUtils.cleanDirectory((File)dir);
    }

    protected static void createDeployDescriptor(Class<?> clazz, File webappsDir, File workDir, File storeDir, File extDir, File jarsDir) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (Config.currentNode().getQuickStartWebApp().booleanValue()) {
            buffer.append("<Configure class=\"org.eclipse.jetty.quickstart.QuickStartWebApp\">");
            buffer.append("<Set name=\"autoPreconfigure\">true</Set>");
        } else {
            buffer.append("<Configure class=\"org.eclipse.jetty.webapp.WebAppContext\">");
        }
        buffer.append("<Set name=\"contextPath\">/" + clazz.getSimpleName() + "</Set>");
        File war = new File(storeDir, clazz.getSimpleName() + ".war");
        buffer.append("<Set name=\"war\">" + war.getAbsolutePath() + "</Set>");
        String extraClasspath = JettySeverTools.calculateExtraClassPath(clazz, extDir, jarsDir);
        buffer.append("\t<Set name=\"extraClasspath\">" + extraClasspath + "</Set>");
        String tempDirectory = new File(workDir, clazz.getSimpleName()).getAbsolutePath();
        buffer.append("\t<Set name=\"tempDirectory\">" + tempDirectory + "</Set>");
        buffer.append("\t</Configure>");
        File file = new File(webappsDir, clazz.getSimpleName() + ".xml");
        FileUtils.write((File)file, (CharSequence)buffer.toString(), (Charset)DefaultCharset.charset);
    }

    private static String calculateExtraClassPath(Class<?> clazz, File extDir, File jarsDir) throws Exception {
        ArrayList<String> jars = new ArrayList<String>();
        jars.addAll(JettySeverTools.calculateExtraClassPathExt(extDir));
        jars.addAll(JettySeverTools.calculateExtraClassPathDependents(clazz, jarsDir));
        return StringUtils.join(jars, (String)";");
    }

    private static List<String> calculateExtraClassPathExt(File extDir) {
        ArrayList<String> jars = new ArrayList<String>();
        WildcardFileFilter filter = new WildcardFileFilter("slf4j-api-*.jar");
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("slf4j-simple-*.jar")});
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("jul-to-slf4j-*.jar")});
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("openjpa-*.jar")});
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("ehcache-*.jar")});
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("jetty-all-*.jar")});
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter("quartz-*.jar")});
        for (File o : FileUtils.listFiles((File)extDir, (IOFileFilter)filter, null)) {
            jars.add(o.getAbsolutePath());
        }
        return jars;
    }

    private static List<String> calculateExtraClassPathDependents(Class<?> clazz, File jarsDir) throws Exception {
        ArrayList<String> jars = new ArrayList<String>();
        IOFileFilter filter = FalseFileFilter.FALSE;
        List list = (List)FieldUtils.readStaticField(clazz, (String)"dependents");
        for (Serializable o : list) {
            filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filter, new WildcardFileFilter(((Class)o).getSimpleName() + ".jar")});
        }
        for (Serializable o : FileUtils.listFiles((File)jarsDir, (IOFileFilter)filter, null)) {
            jars.add(((File)o).getAbsolutePath());
        }
        return jars;
    }
}

