/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.storage;

import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.StorageServer;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.server.console.server.storage.StorageUserManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class StorageServerTools {
    private static Logger logger = LoggerFactory.getLogger(StorageServerTools.class);

    public static FtpServer start(StorageServer storageServer) throws Exception {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ConnectionConfigFactory connectionConfigFactory = new ConnectionConfigFactory();
        connectionConfigFactory.setAnonymousLoginEnabled(false);
        connectionConfigFactory.setMaxLogins(1000);
        connectionConfigFactory.setMaxThreads(1000);
        ListenerFactory listenerFactory = new ListenerFactory();
        DataConnectionConfigurationFactory dataConnectionConfigurationFactory = new DataConnectionConfigurationFactory();
        dataConnectionConfigurationFactory.setPassivePorts(storageServer.getPassivePorts());
        dataConnectionConfigurationFactory.setPassiveIpCheck(false);
        listenerFactory.setDataConnectionConfiguration(dataConnectionConfigurationFactory.createDataConnectionConfiguration());
        listenerFactory.setPort(storageServer.getPort().intValue());
        Listener listener = listenerFactory.createListener();
        serverFactory.addListener("default", listener);
        serverFactory.setConnectionConfig(connectionConfigFactory.createConnectionConfig());
        serverFactory.setUserManager(StorageServerTools.calculateUserManager(storageServer.getCalculatedAccounts()));
        FtpServer server = serverFactory.createServer();
        server.start();
        logger.print("storage server start on port:{}.", new Object[]{storageServer.getPort()});
        return server;
    }

    public static void stop(FtpServer server) throws Exception {
        if (server != null && !server.isStopped()) {
            server.stop();
        }
    }

    private static UserManager calculateUserManager(List<StorageServer.Account> list) throws Exception {
        return StorageServerTools.concreteUserManager(list);
    }

    private static UserManager concreteUserManager(List<StorageServer.Account> list) throws Exception {
        ArrayList<BaseUser> users = new ArrayList<BaseUser>();
        for (StorageServer.Account o : list) {
            BaseUser user = new BaseUser();
            user.setEnabled(true);
            user.setName(o.getUsername());
            String password = o.getPassword();
            if (StringUtils.isEmpty((CharSequence)password)) {
                password = Config.token().getPassword();
            }
            user.setPassword(password);
            File file = new File(Config.base(), "local/repository/storage/" + o.getUsername());
            FileUtils.forceMkdir((File)file);
            user.setHomeDirectory(file.getAbsolutePath());
            user.setMaxIdleTime(0);
            ArrayList<Object> authorities = new ArrayList<Object>();
            authorities.add(new WritePermission());
            authorities.add(new ConcurrentLoginPermission(0, 0));
            authorities.add(new TransferRatePermission(0, 0));
            user.setAuthorities(authorities);
            users.add(user);
        }
        StorageUserManager userManager = new StorageUserManager(users);
        return userManager;
    }
}

