/*
 * Decompiled with CFR 0.152.
 */
package com.x.server.console.server.web;

import com.google.gson.Gson;
import com.x.base.core.project.config.Config;
import com.x.base.core.project.config.WebServer;
import com.x.base.core.project.gson.XGsonBuilder;
import com.x.base.core.project.logger.Logger;
import com.x.base.core.project.logger.LoggerFactory;
import com.x.base.core.project.tools.DefaultCharset;
import com.x.base.core.project.tools.Host;
import com.x.server.console.server.JettySeverTools;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServerTools
extends JettySeverTools {
    private static Logger logger = LoggerFactory.getLogger(WebServerTools.class);
    private static int WEBSERVER_THREAD_POOL_SIZE_MIN = 10;
    private static int WEBSERVER_THREAD_POOL_SIZE_MAX = 100;

    public static Server start(WebServer webServer) throws Exception {
        WebServerTools.updateCenterConfigJson();
        WebServerTools.createIndexPage();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(WEBSERVER_THREAD_POOL_SIZE_MIN);
        threadPool.setMaxThreads(WEBSERVER_THREAD_POOL_SIZE_MAX);
        Server server = new Server((ThreadPool)threadPool);
        if (webServer.getSslEnable().booleanValue()) {
            WebServerTools.addHttpsConnector(server, webServer.getPort());
        } else {
            WebServerTools.addHttpConnector(server, webServer.getPort());
        }
        WebAppContext context = new WebAppContext();
        context.setContextPath("/");
        context.setBaseResource(Resource.newResource((File)new File(Config.base(), "servers/webServer")));
        context.setParentLoaderPriority(true);
        context.setExtractWAR(false);
        context.setDefaultsDescriptor(new File(Config.base(), "commons/webdefault_w.xml").getAbsolutePath());
        context.setWelcomeFiles(new String[]{"index.html"});
        context.setGzipHandler(new GzipHandler());
        context.setParentLoaderPriority(true);
        server.setHandler((Handler)context);
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        server.start();
        context.setMimeTypes(Config.mimeTypes());
        logger.print("web server start completed on port: {}.", new Object[]{webServer.getPort()});
        return server;
    }

    private static void updateCenterConfigJson() throws Exception {
        String host;
        File file = new File(Config.base(), "servers/webServer/x_desktop/res/config/config.json");
        Gson gson = XGsonBuilder.instance();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.putAll(Config.centerServer().getConfig());
        ArrayList centers = new ArrayList();
        map.put("center", centers);
        HashMap<String, String> center = new HashMap<String, String>();
        center = new HashMap();
        center.put("host", "");
        center.put("port", Config.centerServer().getPort().toString());
        centers.add(center);
        if (!Objects.equals(Config.centerServer().getProxyPort(), Config.centerServer().getPort())) {
            center = new HashMap();
            center.put("host", "");
            center.put("port", Config.centerServer().getProxyPort().toString());
            centers.add(center);
        }
        if (!Host.isRollback((String)(host = Config.nodes().primaryCenterNode())).booleanValue()) {
            center = new HashMap();
            center.put("host", host);
            center.put("port", Config.centerServer().getPort().toString());
            centers.add(center);
        }
        if (StringUtils.isNotEmpty((CharSequence)Config.centerServer().getProxyHost())) {
            center = new HashMap();
            center.put("host", Config.centerServer().getProxyHost());
            center.put("port", Config.centerServer().getProxyPort().toString());
            centers.add(center);
        }
        map.put("initManagerChanged", true);
        map.put("initManagerName", "");
        map.put("initManagerPassword", "");
        if (StringUtils.equals((CharSequence)Config.token().initialManagerInstance().getName(), (CharSequence)"xadmin") && StringUtils.equals((CharSequence)Config.token().getPassword(), (CharSequence)"o2")) {
            map.put("initManagerChanged", false);
            map.put("initManagerName", "xadmin");
            map.put("initManagerPassword", "o2");
        }
        map.put("footer", Config.collect().getFooter());
        map.put("title", Config.collect().getTitle());
        if (Config.centerServer().getSslEnable().booleanValue()) {
            map.put("app_protocol", "https:");
        } else {
            map.put("app_protocol", "http:");
        }
        map.put("app_protocol", "auto");
        map.put("loginPage", Config.person().getLoginPage());
        FileUtils.writeStringToFile((File)file, (String)gson.toJson(map), (Charset)DefaultCharset.charset);
    }

    private static void createIndexPage() throws Exception {
        if (null != Config.nodes().webServers()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<!DOCTYPE html>");
            buffer.append("<html>");
            buffer.append("<head>");
            buffer.append("<meta charset=\"UTF-8\">");
            buffer.append("<title>o2 index</title>");
            buffer.append("\t</head>");
            buffer.append("<body>");
            for (Map.Entry en : Config.nodes().webServers().entrySet()) {
                WebServer o = (WebServer)en.getValue();
                if (!BooleanUtils.isTrue((Boolean)o.getEnable())) continue;
                String url = BooleanUtils.isTrue((Boolean)o.getSslEnable()) ? "https://" : "http://";
                url = url + (String)en.getKey();
                if (BooleanUtils.isTrue((Boolean)o.getSslEnable())) {
                    if (o.getPort() != 443) {
                        url = url + ":" + o.getPort();
                    }
                } else if (o.getPort() != 80) {
                    url = url + ":" + o.getPort();
                }
                buffer.append("<a href=\"" + url + "\">" + url + "</a><br/>");
            }
            buffer.append("</body>");
            buffer.append("</html>");
            File file = new File(Config.base(), "index.html");
            FileUtils.write((File)file, (CharSequence)buffer.toString(), (String)DefaultCharset.name);
        }
    }
}

