/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.Assert;
import org.junit.Test;

public class PhoneticEngineRegressionTest {
    @Test
    public void testSolrGENERIC() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "GENERIC");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anZelo|andZelo|angelo|anhelo|anjelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"(anZelo|andZelo|angelo|anhelo|anjelo|anxelo)-(danZelo|dandZelo|dangelo|danhelo|danjelo|danxelo)");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"andZelo|angelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anZelo|andZelo|angelo|anhelo|anjelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"(anZelo|andZelo|angelo|anhelo|anjelo|anxelo)-(danZelo|dandZelo|dangelo|danhelo|danjelo|danxelo)");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"andZelo|angelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"(agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo)-(dagilo|dangilo|daniilo|danilo|danxilo|danzilo|dogilo|dongilo|doniilo|donilo|donxilo|donzilo)");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"angilo|anxilo|anzilo|ongilo|onxilo|onzilo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"(agilo|angilo|aniilo|anilo|anxilo|anzilo|ogilo|ongilo|oniilo|onilo|onxilo|onzilo)-(dagilo|dangilo|daniilo|danilo|danxilo|danzilo|dogilo|dongilo|doniilo|donilo|donxilo|donzilo)");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"angilo|anxilo|anzilo|ongilo|onxilo|onzilo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    @Test
    public void testSolrASHKENAZI() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "ASHKENAZI");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"andZelo|angelo|anhelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"dandZelo|dangelo|danhelo|danxelo");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"angelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"andZelo|angelo|anhelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"dandZelo|dangelo|danhelo|danxelo");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"angelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"dAnElO|dAnSelO|dAngElO|dAngzelO|dAnkselO|dAnzelO");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"AnSelO|AngElO|AngzelO|AnkselO");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "ASHKENAZI");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"AnElO|AnSelO|AngElO|AngzelO|AnkselO|AnzelO");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"dAnElO|dAnSelO|dAngElO|dAngzelO|dAnkselO|dAnzelO");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"AnSelO|AngElO|AngzelO|AnkselO");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    @Test
    public void testSolrSEPHARDIC() {
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("nameType", "SEPHARDIC");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anZelo|andZelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"anZelo|andZelo|anxelo");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"andZelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        args.put("ruleType", "EXACT");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anZelo|andZelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"danZelo|dandZelo|danxelo");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"andZelo|anxelo");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "D'Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, true, "1234"), (Object)"");
        args = new TreeMap();
        args.put("nameType", "SEPHARDIC");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        args.put("ruleType", "APPROX");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "D'Angelo"), (Object)"danhila|danhilu|danzila|danzilu|nhila|nhilu|nzila|nzilu");
        args.put("languageSet", "italian,greek,spanish");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "Angelo"), (Object)"anhila|anhilu|anzila|anzilu|nhila|nhilu|nzila|nzilu");
        Assert.assertEquals((Object)PhoneticEngineRegressionTest.encode(args, false, "1234"), (Object)"");
    }

    private static String encode(Map<String, String> args, boolean concat, String input) {
        String nameTypeArg = args.get("nameType");
        NameType nameType = nameTypeArg == null ? NameType.GENERIC : NameType.valueOf((String)nameTypeArg);
        String ruleTypeArg = args.get("ruleType");
        RuleType ruleType = ruleTypeArg == null ? RuleType.APPROX : RuleType.valueOf((String)ruleTypeArg);
        PhoneticEngine engine = new PhoneticEngine(nameType, ruleType, concat);
        String languageSetArg = args.get("languageSet");
        Languages.LanguageSet languageSet = languageSetArg == null || languageSetArg.equals("auto") ? null : Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(languageSetArg.split(","))));
        if (languageSet == null) {
            return engine.encode(input);
        }
        return engine.encode(input, languageSet);
    }
}

