/*
 * Decompiled with CFR 0.152.
 */
package com.wx.pwd;

import com.wx.pwd.StringUtils;

public class CheckStrength {
    private static final int NUM = 1;
    private static final int SMALL_LETTER = 2;
    private static final int CAPITAL_LETTER = 3;
    private static final int OTHER_CHAR = 4;
    private static final String[] DICTIONARY = new String[]{"password", "abc123", "iloveyou", "adobe123", "123123", "sunshine", "1314520", "a1b2c3", "123qwe", "aaa111", "qweasd", "admin", "passwd"};

    private static int checkCharacterType(char c) {
        if (c >= '0' && c <= '9') {
            return 1;
        }
        if (c >= 'A' && c <= 'Z') {
            return 3;
        }
        if (c >= 'a' && c <= 'z') {
            return 2;
        }
        return 4;
    }

    private static int countLetter(String passwd, int type) {
        int count = 0;
        if (null != passwd && passwd.length() > 0) {
            for (char c : passwd.toCharArray()) {
                if (CheckStrength.checkCharacterType(c) != type) continue;
                ++count;
            }
        }
        return count;
    }

    public static int checkPasswordStrength(String passwd) {
        String part2;
        String part1;
        if (StringUtils.equalsNull(passwd)) {
            throw new IllegalArgumentException("password is empty");
        }
        int len = passwd.length();
        int level = 0;
        if (CheckStrength.countLetter(passwd, 1) > 0) {
            ++level;
        }
        if (CheckStrength.countLetter(passwd, 2) > 0) {
            ++level;
        }
        if (len > 4 && CheckStrength.countLetter(passwd, 3) > 0) {
            ++level;
        }
        if (len > 6 && CheckStrength.countLetter(passwd, 4) > 0) {
            ++level;
        }
        if (len > 4 && CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 2) > 0 || CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 3) > 0 || CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 4) > 0 || CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 3) > 0 || CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 4) > 0 || CheckStrength.countLetter(passwd, 3) > 0 && CheckStrength.countLetter(passwd, 4) > 0) {
            ++level;
        }
        if (len > 6 && CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 3) > 0 || CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 4) > 0 || CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 3) > 0 && CheckStrength.countLetter(passwd, 4) > 0 || CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 3) > 0 && CheckStrength.countLetter(passwd, 4) > 0) {
            ++level;
        }
        if (len > 8 && CheckStrength.countLetter(passwd, 1) > 0 && CheckStrength.countLetter(passwd, 2) > 0 && CheckStrength.countLetter(passwd, 3) > 0 && CheckStrength.countLetter(passwd, 4) > 0) {
            ++level;
        }
        if (len > 6 && CheckStrength.countLetter(passwd, 1) >= 3 && CheckStrength.countLetter(passwd, 2) >= 3 || CheckStrength.countLetter(passwd, 1) >= 3 && CheckStrength.countLetter(passwd, 3) >= 3 || CheckStrength.countLetter(passwd, 1) >= 3 && CheckStrength.countLetter(passwd, 4) >= 2 || CheckStrength.countLetter(passwd, 2) >= 3 && CheckStrength.countLetter(passwd, 3) >= 3 || CheckStrength.countLetter(passwd, 2) >= 3 && CheckStrength.countLetter(passwd, 4) >= 2 || CheckStrength.countLetter(passwd, 3) >= 3 && CheckStrength.countLetter(passwd, 4) >= 2) {
            ++level;
        }
        if (len > 8 && CheckStrength.countLetter(passwd, 1) >= 2 && CheckStrength.countLetter(passwd, 2) >= 2 && CheckStrength.countLetter(passwd, 3) >= 2 || CheckStrength.countLetter(passwd, 1) >= 2 && CheckStrength.countLetter(passwd, 2) >= 2 && CheckStrength.countLetter(passwd, 4) >= 2 || CheckStrength.countLetter(passwd, 1) >= 2 && CheckStrength.countLetter(passwd, 3) >= 2 && CheckStrength.countLetter(passwd, 4) >= 2 || CheckStrength.countLetter(passwd, 2) >= 2 && CheckStrength.countLetter(passwd, 3) >= 2 && CheckStrength.countLetter(passwd, 4) >= 2) {
            ++level;
        }
        if (len > 10 && CheckStrength.countLetter(passwd, 1) >= 2 && CheckStrength.countLetter(passwd, 2) >= 2 && CheckStrength.countLetter(passwd, 3) >= 2 && CheckStrength.countLetter(passwd, 4) >= 2) {
            ++level;
        }
        if (CheckStrength.countLetter(passwd, 4) >= 3) {
            ++level;
        }
        if (CheckStrength.countLetter(passwd, 4) >= 6) {
            ++level;
        }
        if (len > 12) {
            ++level;
            if (len >= 16) {
                ++level;
            }
        }
        if ("abcdefghijklmnopqrstuvwxyz".indexOf(passwd) > 0 || "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(passwd) > 0) {
            --level;
        }
        if ("qwertyuiop".indexOf(passwd) > 0 || "asdfghjkl".indexOf(passwd) > 0 || "zxcvbnm".indexOf(passwd) > 0) {
            --level;
        }
        if (StringUtils.isNumeric(passwd) && ("01234567890".indexOf(passwd) > 0 || "09876543210".indexOf(passwd) > 0)) {
            --level;
        }
        if (CheckStrength.countLetter(passwd, 1) == len || CheckStrength.countLetter(passwd, 2) == len || CheckStrength.countLetter(passwd, 3) == len) {
            --level;
        }
        if (len % 2 == 0) {
            part1 = passwd.substring(0, len / 2);
            if (part1.equals(part2 = passwd.substring(len / 2))) {
                --level;
            }
            if (StringUtils.isCharEqual(part1) && StringUtils.isCharEqual(part2)) {
                --level;
            }
        }
        if (len % 3 == 0) {
            part1 = passwd.substring(0, len / 3);
            part2 = passwd.substring(len / 3, len / 3 * 2);
            String part3 = passwd.substring(len / 3 * 2);
            if (part1.equals(part2) && part2.equals(part3)) {
                --level;
            }
        }
        if (StringUtils.isNumeric(passwd) && len >= 6) {
            int year = 0;
            if (len == 8 || len == 6) {
                year = Integer.parseInt(passwd.substring(0, len - 4));
            }
            int size = StringUtils.sizeOfInt(year);
            int month = Integer.parseInt(passwd.substring(size, size + 2));
            int day = Integer.parseInt(passwd.substring(size + 2, len));
            if (year >= 1950 && year < 2050 && month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                --level;
            }
        }
        if (null != DICTIONARY && DICTIONARY.length > 0) {
            for (int i = 0; i < DICTIONARY.length; ++i) {
                if (!passwd.equals(DICTIONARY[i]) && DICTIONARY[i].indexOf(passwd) < 0) continue;
                --level;
                break;
            }
        }
        if (len <= 6) {
            --level;
            if (len <= 4) {
                --level;
                if (len <= 3) {
                    level = 0;
                }
            }
        }
        if (StringUtils.isCharEqual(passwd)) {
            level = 0;
        }
        if (level < 0) {
            level = 0;
        }
        return level;
    }

    public static LEVEL getPasswordLevel(String passwd) {
        int level = CheckStrength.checkPasswordStrength(passwd);
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return LEVEL.EASY;
            }
            case 4: 
            case 5: 
            case 6: {
                return LEVEL.MIDIUM;
            }
            case 7: 
            case 8: 
            case 9: {
                return LEVEL.STRONG;
            }
            case 10: 
            case 11: 
            case 12: {
                return LEVEL.VERY_STRONG;
            }
        }
        return LEVEL.EXTREMELY_STRONG;
    }

    public static enum LEVEL {
        EASY,
        MIDIUM,
        STRONG,
        VERY_STRONG,
        EXTREMELY_STRONG;

    }
}

