/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClasspathFinder {
    private final NestedJarHandler nestedJarHandler;
    private static String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final List<ClassLoader> classLoaderOrder;
    private final List<ClasspathRelativePath> rawClasspathElements = new ArrayList<ClasspathRelativePath>();
    private final Set<ClasspathRelativePath> rawClasspathElementsSet = new HashSet<ClasspathRelativePath>();

    private void addClasspathElement(ClasspathRelativePath classpathEltPath, LogNode log) {
        if (this.rawClasspathElementsSet.add(classpathEltPath)) {
            this.rawClasspathElements.add(classpathEltPath);
            if (log != null) {
                log.log("Found classpath element: " + classpathEltPath);
            }
        } else if (log != null) {
            log.log("Ignoring duplicate classpath element: " + classpathEltPath);
        }
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        this.addClasspathElement(new ClasspathRelativePath(currDirPathStr, pathElement, Arrays.asList(classLoader), this.nestedJarHandler), log);
        return true;
    }

    public boolean addClasspathElement(String pathElement, List<ClassLoader> classLoaders, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        this.addClasspathElement(new ClasspathRelativePath(currDirPathStr, pathElement, classLoaders, this.nestedJarHandler), log);
        return true;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        for (String pathElement : pathStr.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement, classLoader, log);
        }
        return true;
    }

    public boolean addClasspathElements(String pathStr, List<ClassLoader> classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        for (String pathElement : pathStr.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement, classLoaders, log);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        this.classLoaderOrder = ClassLoaderFinder.findClassLoaders(scanSpec, log == null ? null : log.log("Finding ClassLoaders"));
        LogNode parentClassLoaderLog = log == null ? null : log.log("Finding parent ClassLoaders");
        AdditionOrderedSet<ClassLoader> allClassLoaders = new AdditionOrderedSet<ClassLoader>();
        for (ClassLoader classLoader : this.classLoaderOrder) {
            void var9_9;
            void var9_11;
            Iterator<Class<? extends ClassLoaderHandler>> parentClassLoaders = new ArrayList<void>();
            ClassLoader classLoader2 = classLoader;
            while (var9_11 != null) {
                ((ArrayList)((Object)parentClassLoaders)).add((Class<? extends ClassLoaderHandler>)var9_11);
                ClassLoader classLoader3 = var9_11.getParent();
            }
            int n = ((ArrayList)((Object)parentClassLoaders)).size() - 1;
            while (var9_9 >= 0) {
                ClassLoader classLoader4 = (ClassLoader)((ArrayList)((Object)parentClassLoaders)).get((int)var9_9);
                if (parentClassLoaderLog != null && var9_9 > 0) {
                    parentClassLoaderLog.log("ClassLoader " + classLoader4 + " is parent of ClassLoader" + ((ArrayList)((Object)parentClassLoaders)).get((int)(var9_9 - true)));
                }
                allClassLoaders.add(classLoader4);
                --var9_9;
            }
        }
        List<ClassLoader> allClassLoadersOrdered = allClassLoaders.getList();
        this.nestedJarHandler = nestedJarHandler;
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && log != null) {
                log.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = log == null ? null : log.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, allClassLoadersOrdered, overrideLog);
            if (overrideLog != null) {
                log.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String rtJarPath;
            if (!scanSpec.blacklistSystemJars() && (rtJarPath = JarUtils.getRtJarPath()) != null) {
                this.addClasspathElement(rtJarPath, allClassLoadersOrdered, log);
            }
            ArrayList<Object> classLoaderHandlers = new ArrayList<Object>();
            for (Class clazz : scanSpec.extraClassLoaderHandlers) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            for (Class<? extends ClassLoaderHandler> clazz : ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            if (log != null) {
                LogNode classLoaderHandlerLog = log.log("ClassLoaderHandlers loaded:");
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerLog.log(classLoaderHandler.getClass().getName());
                }
            }
            for (ClassLoader classLoader : allClassLoadersOrdered) {
                if (scanSpec.blacklistSystemJars() && classLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) continue;
                LogNode logNode = log == null ? null : log.log("Finding classpath elements in ClassLoader " + classLoader);
                boolean classloaderFound = false;
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    try {
                        if (!classLoaderHandler.handle(classLoader, this, logNode)) continue;
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (logNode == null) continue;
                        logNode.log("Exception in ClassLoaderHandler", e);
                    }
                }
                if (classloaderFound || logNode == null) continue;
                logNode.log("Unknown ClassLoader type, cannot scan classes");
            }
            if (scanSpec.overrideClassLoaders == null) {
                LogNode sysPropLog = log == null ? null : log.log("Getting classpath entries from java.class.path");
                this.addClasspathElements(System.getProperty("java.class.path"), allClassLoadersOrdered, sysPropLog);
            }
        }
    }

    public List<ClasspathRelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    public List<ClassLoader> getClassLoaderOrder() {
        return this.classLoaderOrder;
    }
}

