/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.os.Environment;
import android.support.annotation.VisibleForTesting;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.imagepicker.ExifDataCopier;
import io.flutter.plugins.imagepicker.ImagePickerDelegate;
import io.flutter.plugins.imagepicker.ImageResizer;
import java.io.File;

public class ImagePickerPlugin
implements MethodChannel.MethodCallHandler {
    private static final String CHANNEL = "plugins.flutter.io/image_picker";
    private static final int SOURCE_CAMERA = 0;
    private static final int SOURCE_GALLERY = 1;
    private final PluginRegistry.Registrar registrar;
    private final ImagePickerDelegate delegate;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), CHANNEL);
        File externalFilesDirectory = registrar.activity().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        ExifDataCopier exifDataCopier = new ExifDataCopier();
        ImageResizer imageResizer = new ImageResizer(externalFilesDirectory, exifDataCopier);
        ImagePickerDelegate delegate = new ImagePickerDelegate(registrar.activity(), externalFilesDirectory, imageResizer);
        registrar.addActivityResultListener((PluginRegistry.ActivityResultListener)delegate);
        registrar.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)delegate);
        ImagePickerPlugin instance = new ImagePickerPlugin(registrar, delegate);
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)instance);
    }

    @VisibleForTesting
    ImagePickerPlugin(PluginRegistry.Registrar registrar, ImagePickerDelegate delegate) {
        this.registrar = registrar;
        this.delegate = delegate;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        if (this.registrar.activity() == null) {
            result.error("no_activity", "image_picker plugin requires a foreground activity.", null);
            return;
        }
        if (call.method.equals("pickImage")) {
            int imageSource = (Integer)call.argument("source");
            switch (imageSource) {
                case 1: {
                    this.delegate.chooseImageFromGallery(call, result);
                    break;
                }
                case 0: {
                    this.delegate.takeImageWithCamera(call, result);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid image source: " + imageSource);
                }
            }
        } else if (call.method.equals("pickVideo")) {
            int imageSource = (Integer)call.argument("source");
            switch (imageSource) {
                case 1: {
                    this.delegate.chooseVideoFromGallery(call, result);
                    break;
                }
                case 0: {
                    this.delegate.takeVideoWithCamera(call, result);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid video source: " + imageSource);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown method " + call.method);
        }
    }
}

