/*
 * Decompiled with CFR 0.152.
 */
package net.muliba.accounting.app;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.O2SDKManager;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.model.bo.api.ApiErrorResponse;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.adapter.rxjava.HttpException;
import rx.functions.Action1;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lnet/muliba/accounting/app/ExceptionHandler;", "Lrx/functions/Action1;", "", "context", "Landroid/content/Context;", "onFailure", "Lkotlin/Function1;", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Landroid/content/Context;", "getOnFailure", "()Lkotlin/jvm/functions/Function1;", "call", "t", "showConnectionErrorMessage", "showO2ErrorMessage", "exception", "Lretrofit2/adapter/rxjava/HttpException;", "o2_auth_sdk_release"})
public final class ExceptionHandler
implements Action1<Throwable> {
    @Nullable
    private final Context context;
    @NotNull
    private final Function1<Throwable, Unit> onFailure;

    public void call(@NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        Throwable throwable = t;
        if (throwable instanceof TimeoutException) {
            this.showConnectionErrorMessage();
        } else if (throwable instanceof SocketTimeoutException) {
            this.showConnectionErrorMessage();
        } else if (throwable instanceof ConnectException) {
            this.showConnectionErrorMessage();
        } else if (throwable instanceof HttpException) {
            this.showO2ErrorMessage((HttpException)t);
        } else {
            Log.e((String)"ExceptionHandler", (String)"", (Throwable)t);
        }
        this.onFailure.invoke((Object)t);
    }

    private final void showO2ErrorMessage(HttpException exception) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u54cd\u5e94\u4ee3\u7801:" + exception.code());
        try {
            ResponseBody responseBody = exception.response().errorBody();
            String json = responseBody != null ? responseBody.string() : null;
            Log.e((String)"ExceptionHandler", (String)("http error body:" + json));
            ApiErrorResponse errorResponse = (ApiErrorResponse)O2SDKManager.Companion.instance().getGson().fromJson(json, ApiErrorResponse.class);
            if (errorResponse != null) {
                buffer.append(", \u53cd\u9988\u4fe1\u606f:" + errorResponse.getMessage());
            }
        }
        catch (Exception e1) {
            Log.e((String)"ExceptionHandler", (String)"", (Throwable)e1);
        }
        if (this.context != null) {
            Toast.makeText((Context)this.context, (CharSequence)buffer.toString(), (int)0).show();
        }
    }

    private final void showConnectionErrorMessage() {
        if (this.context != null) {
            Toast.makeText((Context)this.context, (CharSequence)"\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u786e\uff01", (int)0).show();
        }
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Function1<Throwable, Unit> getOnFailure() {
        return this.onFailure;
    }

    public ExceptionHandler(@Nullable Context context, @NotNull Function1<? super Throwable, Unit> onFailure) {
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        this.context = context;
        this.onFailure = onFailure;
    }
}

