/*
 * Decompiled with CFR 0.152.
 */
package net.zoneland.x.bpm.mobile.v1.zoneXBPM.core.download;

import android.util.Log;
import java.io.IOException;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.core.download.DownloadBean;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.core.download.ProgressHandler;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.core.download.ProgressListener;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.core.download.ProgressResponseBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ProgressHelper {
    private static ProgressHandler mHandler;
    private static DownloadBean bean;

    public static void setProgressHander(ProgressHandler hander) {
        mHandler = hander;
    }

    public static OkHttpClient.Builder addProgress(OkHttpClient.Builder builder) {
        if (builder == null) {
            builder = new OkHttpClient.Builder();
        }
        final ProgressListener progressListener = new ProgressListener(){

            @Override
            public void onProgress(long progress, long total, boolean done) {
                if (mHandler == null) {
                    Log.e((String)"ProgressHelper", (String)"progress error\uff0c handler is null");
                    return;
                }
                bean.setBytesRead(progress);
                bean.setContentLength(total);
                bean.setDone(done);
                mHandler.sendMessage(bean);
            }
        };
        builder.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            }
        });
        return builder;
    }

    static {
        bean = new DownloadBean();
    }
}

