/*
 * Decompiled with CFR 0.152.
 */
package net.zoneland.x.bpm.mobile.v1.zoneXBPM.utils;

import android.text.TextUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DateHelper {
    public static SimpleDateFormat defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
    public static SimpleDateFormat df = new SimpleDateFormat("MM-dd");
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static Calendar getJustTimeDay(int dayCount, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, dayCount);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar;
    }

    public static void addDay(Calendar date, int dayCount) {
        date.set(6, date.get(6) + dayCount);
    }

    public static boolean isSleepday(Calendar c) {
        int dw = c.get(7);
        return 1 == dw || 7 == dw;
    }

    public static boolean eqYMD(Calendar start, Calendar end) {
        return start.get(1) == end.get(1) && start.get(2) == end.get(2) && start.get(5) == end.get(5);
    }

    public static boolean lsOrEq(Calendar start, Calendar end) {
        return end.getTimeInMillis() - start.getTimeInMillis() >= 0L;
    }

    public static int diffDay(Calendar start, Calendar end) {
        long total = end.getTimeInMillis() - start.getTimeInMillis();
        return (int)(total / 86400000L);
    }

    public static boolean isFullDiffDay(Calendar start, Calendar end) {
        long total = end.getTimeInMillis() - start.getTimeInMillis();
        return total % 86400000L == 0L;
    }

    public static void cpyYMD(Calendar src, Calendar tar) {
        tar.set(1, src.get(1));
        tar.set(2, src.get(2));
        tar.set(5, src.get(5));
    }

    public static void cpyHMS(Calendar src, Calendar tar) {
        tar.set(11, src.get(11));
        tar.set(12, src.get(12));
        tar.set(13, src.get(13));
    }

    public static Calendar gc(String time) throws ParseException {
        Calendar d = Calendar.getInstance();
        d.setTime(tf.parse(time));
        return d;
    }

    public static Calendar gc(Date date) throws ParseException {
        Calendar d = Calendar.getInstance();
        d.setTime(date);
        return d;
    }

    public static Date addMinute(Date date, int min) {
        long time = date.getTime();
        long milliseconds = time + (long)(min * 60 * 1000);
        Calendar d = Calendar.getInstance();
        d.setTimeInMillis(milliseconds);
        return d.getTime();
    }

    public static Calendar gc(Calendar src, int h, int m, int s) {
        Calendar d = (Calendar)src.clone();
        d.set(11, h);
        d.set(12, m);
        d.set(13, s);
        return d;
    }

    public static Calendar gcBirthDay(Calendar src, int year, int monthOfYear, int dayOfMonth) {
        Calendar d = (Calendar)src.clone();
        d.set(1, year);
        d.set(2, monthOfYear);
        d.set(5, dayOfMonth);
        return d;
    }

    public static Calendar gc(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar d = Calendar.getInstance();
        d.setTime(sdf.parse(date));
        return d;
    }

    public static String now() {
        return defaultFormat.format(new Date());
    }

    public static String nowByFormate(String formate) {
        SimpleDateFormat nowormat = new SimpleDateFormat(formate);
        return nowormat.format(new Date());
    }

    public static final Date convertStringToDate(String aMask, String strDate) {
        if (strDate == null || strDate.trim().equals("")) {
            return null;
        }
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(aMask);
        try {
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        return date;
    }

    public static final Date convertStringToDate(String strDate) {
        if (TextUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        Date date = null;
        try {
            date = defaultFormat.parse(strDate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        return date;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate != null) {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String getDateTime(Date aDate) {
        String returnValue = "";
        if (aDate != null) {
            returnValue = defaultFormat.format(aDate);
        }
        return returnValue;
    }

    public static final String getDate(Date aDate) {
        String returnValue = "";
        if (aDate != null) {
            returnValue = sdf.format(aDate);
        }
        return returnValue;
    }

    public static String getDayBefore(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        long tm = cal.getTimeInMillis();
        long tm1 = tm - 86400000L;
        Date time1 = new Date(tm1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(time1);
    }

    public static Date getJustDay(int type, int count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(type, count);
        return calendar.getTime();
    }

    public static String getPreStrDateByFormat(Date time, String format, int n) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -n);
        time = calendar.getTime();
        if (time == null) {
            return "";
        }
        if (format == null || format.equals("")) {
            return dateFormat.format(time);
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(time);
    }

    public static Date addDay(Date date, int dayCount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, dayCount);
        date = calendar.getTime();
        return date;
    }

    public static boolean isLessNow(String day, String format) {
        Date date = DateHelper.convertStringToDate(format, day);
        if (date == null) {
            return false;
        }
        Date today = new Date();
        return today.getTime() - date.getTime() > 0L;
    }

    public static double hourGap(String start, String end) throws ParseException {
        Calendar startC = DateHelper.gc(start, "yyyy-MM-dd HH:mm:ss");
        Calendar endC = DateHelper.gc(end, "yyyy-MM-dd HH:mm:ss");
        long gapLong = endC.getTimeInMillis() - startC.getTimeInMillis();
        BigDecimal b1 = new BigDecimal(Long.toString(gapLong));
        BigDecimal b2 = new BigDecimal(Long.toString(3600000L));
        return b1.divide(b2, 2, 6).doubleValue();
    }

    public static boolean isToday(Date date) {
        String dateStr;
        String today = DateHelper.nowByFormate("yyyy-MM-dd");
        return today.equals(dateStr = DateHelper.getDate(date));
    }

    public static boolean isYesterday(Date date) {
        Date yesterday;
        String yesterdayStr;
        String dateStr = DateHelper.getDate(date);
        return dateStr.equals(yesterdayStr = DateHelper.getDate(yesterday = DateHelper.addDay(new Date(), -1)));
    }

    public static String getWeekDay(String date, String format) throws ParseException {
        Calendar c = DateHelper.gc(date, format);
        if (c != null) {
            int weekDay = c.get(7);
            switch (weekDay) {
                case 1: {
                    return "\u5468\u65e5";
                }
                case 2: {
                    return "\u5468\u4e00";
                }
                case 3: {
                    return "\u5468\u4e8c";
                }
                case 4: {
                    return "\u5468\u4e09";
                }
                case 5: {
                    return "\u5468\u56db";
                }
                case 6: {
                    return "\u5468\u4e94";
                }
                case 7: {
                    return "\u5468\u516d";
                }
            }
        }
        return "";
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(1);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Calendar getFirstDayOfWeek(Calendar cal) {
        cal.setFirstDayOfWeek(1);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(1);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static Calendar getMonthFirstDay(Calendar day) {
        Calendar newDay = (Calendar)day.clone();
        newDay.set(5, 1);
        return newDay;
    }

    public static Calendar getMonthLastDay(Calendar day) {
        Calendar newDay = (Calendar)day.clone();
        newDay.add(2, 1);
        newDay.set(5, 0);
        return newDay;
    }

    public static String friendlyTime(Date time) {
        int hour;
        String paramDate;
        if (time == null) {
            return "Unknown";
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        String curDate = sdf.format(cal.getTime());
        if (curDate.equals(paramDate = sdf.format(time))) {
            int hour2 = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour2 == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour2 + "\u5c0f\u65f6\u524d";
            return ftime;
        }
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        ftime = days == 0 ? ((hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L)) == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d") : (days == 1 ? "\u6628\u5929" : (days == 2 ? "\u524d\u5929 " : (days > 2 && days < 31 ? days + "\u5929\u524d" : (days >= 31 && days <= 62 ? "\u4e00\u4e2a\u6708\u524d" : (days > 62 && days <= 93 ? "2\u4e2a\u6708\u524d" : (days > 93 && days <= 124 ? "3\u4e2a\u6708\u524d" : sdf.format(time)))))));
        return ftime;
    }

    @NotNull
    public static List<Calendar> splitEveryDay(@NotNull String startTime, @NotNull String endTime) {
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        try {
            Calendar start = DateHelper.gc(startTime, "yyyy-MM-dd HH:mm:ss");
            Calendar end = DateHelper.gc(endTime, "yyyy-MM-dd HH:mm:ss");
            if (DateHelper.isSameDay(start, end)) {
                list.add(start);
            } else if (start.get(1) == end.get(1)) {
                list.add(start);
                int gap = end.get(6) - start.get(6);
                for (int i = 0; i < gap; ++i) {
                    Calendar nwDay = (Calendar)start.clone();
                    nwDay.set(6, nwDay.get(6) + i + 1);
                    list.add(nwDay);
                }
            } else {
                list.add(start);
                int max = start.getActualMaximum(6);
                int startDay = start.get(6);
                int gap = max - startDay + end.get(6);
                for (int i = 0; i < gap; ++i) {
                    Calendar nwDay = (Calendar)start.clone();
                    nwDay.set(6, nwDay.get(6) + i + 1);
                    list.add(nwDay);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean isSameDay(Calendar start, Calendar end) {
        return start.get(1) == end.get(1) && start.get(6) == end.get(6);
    }
}

