/*
 * Decompiled with CFR 0.152.
 */
package net.zoneland.x.bpm.mobile.v1.zoneXBPM.utils;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.util.Date;
import net.zoneland.x.bpm.mobile.v1.zoneXBPM.O2;
import okhttp3.Cache;

public class HttpCacheUtil {
    private static final String TAG = "HttpCacheUtil";
    private static final long CACHESIZE = 0xA00000L;

    public static void clearCache(Context context, int numDays) {
        Log.i((String)TAG, (String)String.format("Starting cache prune, deleting files older than %d days", numDays));
        int numDeletedFiles = HttpCacheUtil.clearCacheFolder(context.getCacheDir(), numDays);
        Log.i((String)TAG, (String)String.format("Cache pruning completed, %d files deleted", numDeletedFiles));
        Toast.makeText((Context)context, (CharSequence)"\u7f13\u5b58\u5df2\u7ecf\u6e05\u9664\uff01", (int)0).show();
    }

    public static Cache getOkHttpCacheInstance(Context context) {
        File cacheFile = new File(context.getCacheDir(), O2.INSTANCE.getHTTP_CACHE_FOLDER());
        Cache cache = new Cache(cacheFile, 0xA00000L);
        return cache;
    }

    private static int clearCacheFolder(File dir, int numDays) {
        int deletedFiles = 0;
        if (dir != null && dir.isDirectory()) {
            Log.i((String)TAG, (String)("cache dir:" + dir.getAbsolutePath()));
            try {
                for (File child : dir.listFiles()) {
                    if (child.isDirectory()) {
                        deletedFiles += HttpCacheUtil.clearCacheFolder(child, numDays);
                    }
                    if (child.lastModified() > new Date().getTime() - (long)numDays * 86400000L || !child.delete()) continue;
                    ++deletedFiles;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)String.format("Failed to clean the cache, error %s", e.getMessage()));
            }
        }
        return deletedFiles;
    }
}

