/*
 * Decompiled with CFR 0.152.
 */
package android.devkit.api;

import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;
    private static LoopBuf mLoopBuf;
    private Vector<Driver> mDrivers = null;

    static {
        System.loadLibrary("DevKitApi");
    }

    public SerialPort() {
    }

    public SerialPort(String dev, int baudrate, int flags) throws SecurityException, IOException {
        File device = new File(dev);
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/bin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\n" + "exit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException();
            }
        }
        this.mFd = SerialPort.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        mLoopBuf = new LoopBuf();
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    Vector<Driver> getDrivers() throws IOException {
        if (this.mDrivers == null) {
            String l;
            this.mDrivers = new Vector();
            LineNumberReader r = new LineNumberReader(new FileReader("/proc/tty/drivers"));
            while ((l = r.readLine()) != null) {
                String drivername = l.substring(0, 21).trim();
                String[] w = l.split(" +");
                if (w.length < 5 || !w[w.length - 1].equals("serial")) continue;
                Log.d((String)TAG, (String)("Found new driver " + drivername + " on " + w[w.length - 4]));
                this.mDrivers.add(new Driver(drivername, w[w.length - 4]));
            }
            r.close();
        }
        return this.mDrivers;
    }

    public String[] getAllDevices() {
        Vector<String> devices = new Vector<String>();
        try {
            for (Driver driver : this.getDrivers()) {
                Iterator<File> itdev = driver.getDevices().iterator();
                while (itdev.hasNext()) {
                    String device = itdev.next().getName();
                    String value = String.format("%s (%s)", device, driver.getName());
                    devices.add(value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    public String[] getAllDevicesPath() {
        Vector<String> devices = new Vector<String>();
        try {
            for (Driver driver : this.getDrivers()) {
                Iterator<File> itdev = driver.getDevices().iterator();
                while (itdev.hasNext()) {
                    String device = itdev.next().getAbsolutePath();
                    devices.add(device);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    private static native FileDescriptor open(String var0, int var1, int var2);

    public native void close();

    public LoopBuf getLoopBuf() {
        return mLoopBuf;
    }

    public class Driver {
        private String mDriverName;
        private String mDeviceRoot;
        Vector<File> mDevices = null;

        public Driver(String name, String root) {
            this.mDriverName = name;
            this.mDeviceRoot = root;
        }

        public Vector<File> getDevices() {
            if (this.mDevices == null) {
                this.mDevices = new Vector();
                File dev = new File("/dev");
                File[] files = dev.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].getAbsolutePath().startsWith(this.mDeviceRoot)) {
                        Log.d((String)SerialPort.TAG, (String)("Found new device: " + files[i]));
                        this.mDevices.add(files[i]);
                    }
                    ++i;
                }
            }
            return this.mDevices;
        }

        public String getName() {
            return this.mDriverName;
        }
    }

    public class LoopBuf {
        private Object lock = new Object();
        private byte[] LocalBuffer = new byte[204800];
        private int startIndex = 0;
        private int endIndex = 0;

        public void reset() {
            this.endIndex = 0;
            this.startIndex = 0;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setStartIndex(int index) {
            this.startIndex = index;
        }

        public void setEndIndex(int index) {
            this.endIndex = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(byte[] buf) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.startIndex <= this.endIndex) {
                        if (this.LocalBuffer.length - 1 - this.endIndex >= buf.length) {
                            System.arraycopy(buf, 0, this.LocalBuffer, this.endIndex, buf.length);
                            this.endIndex += buf.length;
                        } else if (this.startIndex + (this.LocalBuffer.length - 1 - this.endIndex) >= buf.length) {
                            int copyLen = this.LocalBuffer.length - 1 - this.endIndex + 1;
                            System.arraycopy(buf, 0, this.LocalBuffer, this.endIndex, copyLen);
                            System.arraycopy(buf, copyLen, this.LocalBuffer, 0, buf.length - copyLen);
                            this.endIndex = buf.length - copyLen;
                        } else {
                            byte[] newBuf = new byte[this.LocalBuffer.length + buf.length * 2];
                            System.arraycopy(this.LocalBuffer, 0, newBuf, 0, this.LocalBuffer.length);
                            System.arraycopy(buf, 0, newBuf, this.endIndex, buf.length);
                            this.endIndex += buf.length;
                            this.LocalBuffer = newBuf;
                        }
                    } else if (this.startIndex - this.endIndex >= buf.length) {
                        System.arraycopy(buf, 0, this.LocalBuffer, this.endIndex, buf.length);
                        this.endIndex += buf.length;
                    } else {
                        byte[] newBuf = new byte[this.LocalBuffer.length + buf.length * 2];
                        System.arraycopy(this.LocalBuffer, 0, newBuf, 0, this.endIndex - 1);
                        System.arraycopy(buf, 0, newBuf, this.endIndex, buf.length);
                        this.endIndex += buf.length;
                        System.arraycopy(this.LocalBuffer, this.startIndex, newBuf, newBuf.length - (this.LocalBuffer.length - this.startIndex), this.LocalBuffer.length - this.startIndex);
                        this.startIndex = newBuf.length - (this.LocalBuffer.length - this.startIndex);
                        this.LocalBuffer = newBuf;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getBuf() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (this.startIndex < this.endIndex) {
                        byte[] tempBuf = new byte[this.endIndex - this.startIndex];
                        System.arraycopy(this.LocalBuffer, this.startIndex, tempBuf, 0, this.endIndex - this.startIndex);
                        return tempBuf;
                    }
                    if (this.startIndex > this.endIndex) {
                        byte[] tempBuf = new byte[this.LocalBuffer.length - this.startIndex + 1 + this.endIndex + 1];
                        System.arraycopy(this.LocalBuffer, this.startIndex, tempBuf, 0, this.LocalBuffer.length - this.startIndex);
                        System.arraycopy(this.LocalBuffer, 0, tempBuf, this.LocalBuffer.length - this.startIndex, this.endIndex + 1);
                        return tempBuf;
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public byte[] GetFullPackBuf() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    int findStartIndex = this.startIndex;
                    int findEndIndex = this.startIndex;
                    boolean findStart = false;
                    boolean findEnd = false;
                    if (this.startIndex < this.endIndex) {
                        while (findStartIndex < this.endIndex - 1) {
                            if ((this.LocalBuffer[findStartIndex] & 0xFF) == 90 && (this.LocalBuffer[findStartIndex + 1] & 0xFF) == 85) {
                                findEndIndex = findStartIndex + 1;
                                findStart = true;
                                break;
                            }
                            ++findStartIndex;
                        }
                        if (findStart) {
                            while (findEndIndex < this.endIndex - 1) {
                                if ((this.LocalBuffer[findEndIndex] & 0xFF) == 106 && (this.LocalBuffer[findEndIndex + 1] & 0xFF) == 105) {
                                    ++findEndIndex;
                                    findEnd = true;
                                    break;
                                }
                                if ((this.LocalBuffer[findEndIndex] & 0xFF) == 90 && (this.LocalBuffer[findEndIndex + 1] & 0xFF) == 85) {
                                    findStartIndex = findEndIndex;
                                }
                                ++findEndIndex;
                            }
                            if (findEnd) {
                                byte[] tempbuf = new byte[findEndIndex - findStartIndex + 1];
                                System.arraycopy(this.LocalBuffer, findStartIndex, tempbuf, 0, findEndIndex - findStartIndex + 1);
                                if (tempbuf == null) {
                                    this.startIndex = findEndIndex + 1;
                                    if (this.startIndex > this.endIndex) {
                                        this.startIndex = this.endIndex;
                                    }
                                    return null;
                                }
                                this.startIndex = findEndIndex + 1;
                                if (this.startIndex > this.endIndex) {
                                    this.startIndex = this.endIndex;
                                }
                                return tempbuf;
                            }
                            return null;
                        }
                        if ((this.LocalBuffer[this.startIndex] & 0xFF) != 90) {
                            ++this.startIndex;
                        }
                        return null;
                    }
                    if (this.startIndex > this.endIndex) {
                        byte[] tempBuf = new byte[this.LocalBuffer.length - this.startIndex + 1 + this.endIndex + 1];
                        System.arraycopy(this.LocalBuffer, this.startIndex, tempBuf, 0, this.LocalBuffer.length - this.startIndex);
                        System.arraycopy(this.LocalBuffer, 0, tempBuf, this.LocalBuffer.length - this.startIndex, this.endIndex + 1);
                        findStartIndex = 0;
                        while (findStartIndex < tempBuf.length - 2) {
                            if ((tempBuf[findStartIndex] & 0xFF) == 90 && (tempBuf[findStartIndex + 1] & 0xFF) == 85) {
                                findEndIndex = findStartIndex + 1;
                                findStart = true;
                                break;
                            }
                            ++findStartIndex;
                        }
                        if (findStart) {
                            while (findEndIndex < tempBuf.length - 2) {
                                if ((tempBuf[findEndIndex] & 0xFF) == 106 && (tempBuf[findEndIndex + 1] & 0xFF) == 105) {
                                    ++findEndIndex;
                                    findEnd = true;
                                    break;
                                }
                                if ((tempBuf[findEndIndex] & 0xFF) == 90 && (tempBuf[findEndIndex + 1] & 0xFF) == 85) {
                                    findStartIndex = findEndIndex;
                                }
                                ++findEndIndex;
                            }
                            if (findEnd) {
                                byte[] tempcheckbuf = new byte[findEndIndex - findStartIndex + 1];
                                System.arraycopy(tempBuf, findStartIndex, tempcheckbuf, 0, findEndIndex - findStartIndex + 1);
                                if (tempcheckbuf == null) {
                                    this.startIndex += findEndIndex + 1;
                                    if (this.startIndex > this.LocalBuffer.length) {
                                        this.startIndex = this.startIndex - this.LocalBuffer.length - 1;
                                        if (this.startIndex > this.endIndex) {
                                            this.startIndex = this.endIndex;
                                        }
                                    }
                                    return null;
                                }
                                this.startIndex += findEndIndex + 1;
                                if (this.startIndex > this.LocalBuffer.length) {
                                    this.startIndex = this.startIndex - this.LocalBuffer.length - 1;
                                    if (this.startIndex > this.endIndex) {
                                        this.startIndex = this.endIndex;
                                    }
                                }
                                return tempcheckbuf;
                            }
                            return null;
                        }
                        if ((this.LocalBuffer[this.startIndex] & 0xFF) != 90) {
                            ++this.startIndex;
                            if (this.startIndex > this.LocalBuffer.length) {
                                this.startIndex = 0;
                                if (this.startIndex > this.endIndex) {
                                    this.startIndex = this.endIndex;
                                }
                            }
                        }
                        return null;
                    }
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

