/*
 * Decompiled with CFR 0.152.
 */
package fosun.sumpay.merchant.integration.core.service;

import fosun.sumpay.merchant.integration.core.service.SignService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;

public class SignServiceImpl
implements SignService {
    private static final String PKCS12 = "PKCS12";
    private static final String X_DOT_509 = "X.509";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";

    @Override
    public boolean verifyMsgOld(String ciphertext, String plaintext, String publicKeyPath) {
        InputStream certfile = null;
        try {
            certfile = SignServiceImpl.class.getClassLoader().getResourceAsStream(publicKeyPath);
            if (certfile == null) {
                certfile = new FileInputStream(publicKeyPath);
            }
            CertificateFactory cf = CertificateFactory.getInstance(X_DOT_509);
            X509Certificate x509cert = (X509Certificate)cf.generateCertificate(certfile);
            RSAPublicKey pubkey = (RSAPublicKey)x509cert.getPublicKey();
            Signature verify = Signature.getInstance(SHA256_WITH_RSA);
            verify.initVerify(pubkey);
            verify.update(plaintext.getBytes("UTF-8"));
            if (verify.verify(Base64.decodeBase64((String)ciphertext))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25", e);
        }
        finally {
            if (certfile != null) {
                try {
                    certfile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public boolean verifyMsgNew(String ciphertext, String plaintext, String publicKeyPath) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    @Override
    public String signMsg(String plaintext, String privateKeyPath, String passWord, String charset) {
        InputStream keyFile = null;
        try {
            keyFile = SignServiceImpl.class.getClassLoader().getResourceAsStream(privateKeyPath);
            if (keyFile == null) {
                keyFile = new FileInputStream(privateKeyPath);
            }
            KeyStore ks = KeyStore.getInstance(PKCS12);
            ks.load(keyFile, passWord.toCharArray());
            Enumeration<String> myEnum = ks.aliases();
            String keyAlias = null;
            RSAPrivateCrtKey prikey = null;
            while (myEnum.hasMoreElements()) {
                keyAlias = myEnum.nextElement();
                if (!ks.isKeyEntry(keyAlias)) continue;
                prikey = (RSAPrivateCrtKey)ks.getKey(keyAlias, passWord.toCharArray());
                break;
            }
            if (prikey == null) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u79c1\u94a5");
            }
            Signature sign = Signature.getInstance(SHA256_WITH_RSA);
            sign.initSign(prikey);
            sign.update(plaintext.getBytes(charset));
            String string = Base64.encodeBase64String((byte[])sign.sign());
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25", e);
        }
        finally {
            if (keyFile != null) {
                try {
                    keyFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String encryptByPublicKey(String plaintext, String publicKeyPath) {
        InputStream certfile = null;
        RSAPublicKey pubkey = null;
        X509Certificate x509cert = null;
        try {
            certfile = SignServiceImpl.class.getClassLoader().getResourceAsStream(publicKeyPath);
            if (certfile == null) {
                certfile = new FileInputStream(publicKeyPath);
            }
            CertificateFactory cf = CertificateFactory.getInstance(X_DOT_509);
            x509cert = (X509Certificate)cf.generateCertificate(certfile);
            pubkey = (RSAPublicKey)x509cert.getPublicKey();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u83b7\u53d6\u516c\u94a5\u5bf9\u8c61\u5931\u8d25", e);
        }
        finally {
            if (certfile != null) {
                try {
                    certfile.close();
                }
                catch (Throwable cf) {}
            }
        }
        try {
            Cipher cipher = Cipher.getInstance(pubkey.getAlgorithm());
            cipher.init(1, pubkey);
            byte[] data = plaintext.getBytes();
            byte[] encrypt = null;
            for (int i = 0; i < data.length; i += 245) {
                byte[] temp = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 245)));
                encrypt = ArrayUtils.addAll(encrypt, (byte[])temp);
            }
            return Base64.encodeBase64String(encrypt);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    @Override
    public String decryptByPrivateKey(String ciphertext, String privateKeyPath, String passWord) {
        InputStream keyFile = null;
        Key prikey = null;
        try {
            keyFile = SignServiceImpl.class.getClassLoader().getResourceAsStream(privateKeyPath);
            if (keyFile == null) {
                keyFile = new FileInputStream(privateKeyPath);
            }
            KeyStore ks = KeyStore.getInstance(PKCS12);
            ks.load(keyFile, passWord.toCharArray());
            Enumeration<String> myEnum = ks.aliases();
            String keyAlias = null;
            while (myEnum.hasMoreElements()) {
                keyAlias = myEnum.nextElement();
                if (!ks.isKeyEntry(keyAlias)) continue;
                prikey = (RSAPrivateCrtKey)ks.getKey(keyAlias, passWord.toCharArray());
                break;
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("\u52a0\u8f7d\u79c1\u94a5\u5931\u8d25", ex);
        }
        finally {
            if (keyFile != null) {
                try {
                    keyFile.close();
                }
                catch (IOException ks) {}
            }
        }
        try {
            Cipher cipher = Cipher.getInstance(prikey.getAlgorithm());
            cipher.init(2, prikey);
            byte[] bytes = Base64.decodeBase64((String)ciphertext);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < bytes.length; i += 256) {
                byte[] decrypt = cipher.doFinal(ArrayUtils.subarray((byte[])bytes, (int)i, (int)(i + 256)));
                result.append(new String(decrypt, "UTF-8"));
            }
            return result.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25", e);
        }
    }
}

