/*
 * Decompiled with CFR 0.152.
 */
package fosun.sumpay.merchant.integration.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import fosun.sumpay.merchant.integration.core.exception.SumpayException;
import fosun.sumpay.merchant.integration.core.request.Request;
import fosun.sumpay.merchant.integration.core.service.SignService;
import fosun.sumpay.merchant.integration.core.service.SignServiceImpl;
import fosun.sumpay.merchant.integration.core.service.SumpayService;
import fosun.sumpay.merchant.integration.core.util.AESUtil;
import fosun.sumpay.merchant.integration.core.util.HttpClientUtil;
import fosun.sumpay.merchant.integration.core.util.ParamUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class SumpayServiceImpl
implements SumpayService {
    private SignService signService = new SignServiceImpl();

    private String processOneObject(String jsonStr, Request request, String aesKey) {
        Map p = (Map)JSON.parseObject((String)jsonStr, Map.class);
        if (p != null && p.size() > 0) {
            this.encrypt(p, aesKey, request.getAesEncodedWords());
            this.specialChange(p, request.getBase64EncodedWords());
            this.charsetChange(p, request.getCharset(), request.getAesEncodedWords());
        }
        String o = JSONObject.toJSONString((Object)p);
        System.out.println("info:" + o);
        return o;
    }

    @Override
    public Map<String, String> execute(Request request) {
        this.checkRequest(request);
        Map params = null;
        try {
            params = (Map)JSON.parseObject((String)request.getContent(), Map.class);
        }
        catch (Throwable e) {
            throw new SumpayException("888888", "\u4e1a\u52a1\u53c2\u6570json\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e");
        }
        String aesKey = AESUtil.getKey();
        if (null != request.getRequestSubParams() && !request.getRequestSubParams().isEmpty()) {
            for (String subName : request.getRequestSubParams().keySet()) {
                if (subName.startsWith("[")) {
                    ArrayList<String> listO = new ArrayList<String>();
                    JSONArray jSONArray = JSONArray.parseArray((String)request.getRequestSubParams().get(subName));
                    for (Object o : jSONArray) {
                        System.out.println("subName:" + subName + ";value:" + o.toString());
                        listO.add(this.processOneObject(o.toString(), request, aesKey));
                    }
                    params.put(subName.substring(1), ((Object)listO).toString());
                    continue;
                }
                System.out.println("subName:" + subName + ";value:" + request.getRequestSubParams().get(subName));
                params.put(subName, this.processOneObject(request.getRequestSubParams().get(subName), request, aesKey));
            }
        }
        this.charsetChange(params, request.getCharset(), request.getCharsetChangeWords());
        this.encrypt(params, aesKey, request.getAesEncodedWords());
        aesKey = this.signService.encryptByPublicKey(aesKey, request.getPublicKeyPath());
        params.put("aes_key", aesKey);
        this.specialChange(params, request.getBase64EncodedWords());
        String plainText = ParamUtil.createLinkString(params);
        boolean bigData = false;
        if (plainText.length() > 200000) {
            bigData = true;
        }
        String sign = this.signService.signMsg(plainText, request.getPrivateKeyPath(), request.getPassword(), "UTF-8");
        params.put("sign", sign);
        params.put("sign_type", "CERT");
        String service = (String)params.get("service");
        if (service == null) {
            throw new SumpayException("888888", "service\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        if (service.indexOf("download") != -1) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            sb.append("<script language=\"javascript\">window.onload=function(){document.pay_form.submit();}</script>\n<form id=\"pay_form\" name=\"pay_form\" action=\"");
            sb.append(request.getUrl()).append("\" method=\"post\">\n");
            for (String key : params.keySet()) {
                sb.append("<input type=\"hidden\" name=\"").append(key).append("\" value=\"").append((String)params.get(key)).append("\">\n");
            }
            sb.append("</form>\n");
            hashMap.put("form", sb.toString());
            hashMap.put("resp_code", "000000");
            return hashMap;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)request.getDomain())) {
            headers.put("Referer", request.getDomain());
        }
        String res = request.isUserMultipart() ? HttpClientUtil.sendPosts(request.getUrl(), params, headers, request.getFileParams(), bigData) : HttpClientUtil.sendPosts(request.getUrl(), params, headers, bigData);
        Map resMap = null;
        if (null == res) {
            throw new SumpayException("888888", "\u54cd\u5e94\u4e3a\u7a7a");
        }
        try {
            resMap = (Map)JSON.parseObject((String)res, Map.class);
            String returnSign = (String)resMap.get("sign");
            String returnSignType = (String)resMap.get("sign_type");
            resMap.remove("sign");
            resMap.remove("sign_type");
            if (null != returnSign && null != returnSignType) {
                if (request.isOld() ? this.signService.verifyMsgOld(returnSign, ParamUtil.createLinkString(resMap), request.getPublicKeyPath()) : this.signService.verifyMsgNew(returnSign, ParamUtil.createLinkString(resMap), request.getPublicKeyPath())) {
                    return resMap;
                }
                throw new SumpayException("888888", "\u6536\u5230\u7684\u54cd\u5e94\u9a8c\u7b7e\u5931\u8d25");
            }
            throw new SumpayException("888888", "\u54cd\u5e94\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        catch (Throwable e) {
            throw new SumpayException(e);
        }
    }

    private String createHeadRequestId(Map<String, String> params) {
        StringBuilder sb = new StringBuilder(params.get("mer_no"));
        if (params.containsKey("order_no")) {
            sb.append("_").append(params.get("order_no"));
        } else if (params.containsKey("request_id")) {
            sb.append("_").append(params.get("request_id"));
        } else {
            sb.append("_").append(UUID.randomUUID().toString().replaceAll("-", ""));
        }
        sb.append("_").append(params.get("timestamp"));
        return sb.toString();
    }

    private void charsetChange(Map<String, String> params, String merCharset, String[] charsetWords) {
        if (null == params || params.size() == 0) {
            throw new RuntimeException("\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set<String> keySet = params.keySet();
        if ("UTF-8".equals(merCharset)) {
            return;
        }
        if (null == charsetWords || charsetWords.length == 0) {
            return;
        }
        for (String field : charsetWords) {
            if (!keySet.contains(field) || null == params.get(field)) continue;
            String value = params.get(field);
            try {
                value = new String(value.getBytes(merCharset), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("\u4f20\u5165\u7684\u7f16\u7801\u4e0d\u5bf9\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e");
            }
            params.put(field, value);
        }
    }

    private void encrypt(Map<String, String> params, String aesKey, String[] aesEncodeWords) {
        if (null == aesEncodeWords || aesEncodeWords.length == 0) {
            return;
        }
        Set<String> keySet = params.keySet();
        for (String field : aesEncodeWords) {
            if (!keySet.contains(field) || null == params.get(field)) continue;
            params.put(field, AESUtil.encode(aesKey, params.get(field)));
        }
    }

    private void specialChange(Map<String, String> params, String[] base64EncodeWords) {
        try {
            if (null == base64EncodeWords || base64EncodeWords.length == 0) {
                return;
            }
            Set<String> keySet = params.keySet();
            for (String field : base64EncodeWords) {
                if (!keySet.contains(field) || null == params.get(field)) continue;
                params.put(field, Base64.encodeBase64String((byte[])params.get(field).getBytes("UTF-8")));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("BASE64\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private void checkRequest(Request request) {
        if (null == request.getCharset() || "".equals(request.getCharset().trim())) {
            throw new SumpayException("888888", "\u8bf7\u6c42\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getContent() || "".equals(request.getContent().trim())) {
            throw new SumpayException("888888", "\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getPassword() || "".equals(request.getPassword().trim())) {
            throw new SumpayException("888888", "\u79c1\u94a5\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getPrivateKeyPath() || "".equals(request.getPrivateKeyPath().trim())) {
            throw new SumpayException("888888", "\u5546\u6237\u79c1\u94a5\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getPublicKeyPath() || "".equals(request.getPublicKeyPath().trim())) {
            throw new SumpayException("888888", "\u7edf\u7edf\u4ed8\u516c\u94a5\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getUrl() || "".equals(request.getUrl().trim())) {
            throw new SumpayException("888888", "\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

