/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg.app;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessException;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessInfo;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessor;
import org.libjpegturbo.turbojpeg.processor.impl.ImageProcessorImpl;
import org.libjpegturbo.turbojpeg.processor.utils.ImageProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MozJpegGalleryApp {
    protected static final int[] QUALITIES = new int[]{100, 95, 90, 85, 80, 70, 60};
    protected static final String VERSION = TJ.getDefaultVersion();
    private static final Logger log = LoggerFactory.getLogger(MozJpegGalleryApp.class);
    private static final ImageProcessor processor = new ImageProcessorImpl();

    public static void main(String[] args) throws IOException, ImageProcessException {
        File[] images;
        if (args.length < 1 || args[0].isEmpty()) {
            throw new IllegalArgumentException("Output directory for the report is not specified");
        }
        File outDir = MozJpegGalleryApp.initOutDirectory(args[0]);
        FileWriter writer = new FileWriter(outDir.getPath() + File.separator + "index.html", true);
        BufferedWriter html = new BufferedWriter(writer);
        html.write("<html><body><h1>MozJpeg Compression Examples (Version " + VERSION + ")</h1><hr>\r\n");
        for (File image : images = MozJpegGalleryApp.getImagesFromResources()) {
            Path inImage = Paths.get(outDir.getPath() + File.separator + image.getName(), new String[0]);
            Files.copy(Paths.get(image.getPath(), new String[0]), inImage, new CopyOption[0]);
            long inImageSize = inImage.toFile().length();
            for (int i = 0; i < QUALITIES.length; ++i) {
                int q = QUALITIES[i];
                String outImageName = "proc_" + q + "_" + image.getName();
                Path outImage = Paths.get(outDir.getPath() + File.separator + outImageName, new String[0]);
                log.info("Processing image with quality={}: {}", (Object)q, (Object)inImage.getFileName());
                long startTime = System.currentTimeMillis();
                ImageProcessInfo processInfo = ImageProcessInfo.fromMap(ImageProcessorUtils.compressImage(processor, inImage.toFile(), outImage.toFile(), q));
                long totalTime = System.currentTimeMillis() - startTime;
                long outImageSize = outImage.toFile().length();
                log.info("Total time: {} msec", (Object)totalTime);
                html.write("<h2>" + inImage.getFileName() + "</h2>\r\n");
                html.write("<h3>Quality: " + q + "<br>\r\n");
                html.write("In/Out Dimension: " + processInfo.getInputDimension() + " / " + processInfo.getOutputDimension() + "<br>");
                html.write("In/Out Size: " + MozJpegGalleryApp.toReadableByteCount(inImageSize, false) + " / " + MozJpegGalleryApp.toReadableByteCount(outImageSize, false) + " => " + MozJpegGalleryApp.getPercent(inImageSize, outImageSize) + "%<br>\r\n");
                html.write("Conversion time: " + totalTime + " msec</h3><br>\n");
                html.write("<img src='" + image.getName() + "'>&nbsp&nbsp&nbsp<img src='" + outImageName + "'><br>\r\n");
            }
            html.write("<br><hr>\r\n");
        }
        html.write("</body></html>");
        html.close();
    }

    public static File initOutDirectory(String outPath) throws IOException {
        File outDir = new File(outPath = outPath + File.separator + "jpeg_compression");
        if (outDir.exists()) {
            MozJpegGalleryApp.deleteDirectory(outDir);
        }
        outDir.mkdirs();
        return outDir;
    }

    public static File[] getImagesFromResources() throws IOException {
        URL resImages = MozJpegGalleryApp.class.getResource("/images");
        File resFolder = null;
        try {
            resFolder = new File(resImages.toURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resFolder != null && resFolder.isDirectory()) {
            return resFolder.listFiles();
        }
        return new File[0];
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    MozJpegGalleryApp.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    public static String toReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static int getPercent(long in, long out) {
        return (int)((double)out / (double)in * 100.0);
    }
}

