/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

import com.alipay.mychain.eInvoice.mycrypto.GenerateRandomStream;
import com.alipay.mychain.eInvoice.mycrypto.LoadNativeMyCrypto;
import com.alipay.mychain.eInvoice.mycrypto.MyCryptoStatus;

public class MycryptoCiphers {
    public static byte[] sm3Hash(byte[] inbuf) {
        byte[] md = new byte[32];
        int ret = LoadNativeMyCrypto.sm3HashNative(md, inbuf, inbuf.length);
        MyCryptoStatus status = MyCryptoStatus.getStatusByCode(ret);
        MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus: " + (Object)((Object)status));
        return md;
    }

    public static byte[] sm3KDF(byte[] inbuf, int outbufLen) {
        byte[] outbuf = new byte[outbufLen];
        int ret = LoadNativeMyCrypto.sm3KDFNative(outbuf, outbufLen, inbuf, inbuf.length);
        MyCryptoStatus status = MyCryptoStatus.getStatusByCode(ret);
        MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus: " + (Object)((Object)status));
        return outbuf;
    }

    private static int getSm4CbcEncCiphertextLen(int pLen) {
        return (pLen >> 4) + 2 << 4;
    }

    public static byte[] sm4CbcEncryptWithMac(byte[] encKey, byte[] macKey, byte[] plaintext) {
        int[] ciphertextLen = new int[]{MycryptoCiphers.getSm4CbcEncCiphertextLen(plaintext.length)};
        byte[] ciphertextBuffer = new byte[ciphertextLen[0]];
        byte[] iv = GenerateRandomStream.getBytes(16);
        int ret = LoadNativeMyCrypto.sm4CbcEncryptWithMacNative(encKey, macKey, iv, plaintext, plaintext.length, ciphertextBuffer, ciphertextLen);
        MyCryptoStatus status = MyCryptoStatus.getStatusByCode(ret);
        MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus: " + (Object)((Object)status));
        byte[] ciphertext = new byte[ciphertextLen[0] + 16];
        System.arraycopy(iv, 0, ciphertext, 0, 16);
        System.arraycopy(ciphertextBuffer, 0, ciphertext, 16, ciphertextLen[0]);
        return ciphertext;
    }

    public static byte[] sm4CbcEncryptWithMac(byte[] encKey, byte[] macKey, byte[] iv, byte[] plaintext) {
        int[] ciphertextLen = new int[]{MycryptoCiphers.getSm4CbcEncCiphertextLen(plaintext.length)};
        byte[] ciphertextBuffer = new byte[ciphertextLen[0]];
        int ret = LoadNativeMyCrypto.sm4CbcEncryptWithMacNative(encKey, macKey, iv, plaintext, plaintext.length, ciphertextBuffer, ciphertextLen);
        MyCryptoStatus status = MyCryptoStatus.getStatusByCode(ret);
        MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus: " + (Object)((Object)status));
        byte[] ciphertext = new byte[ciphertextLen[0] + 16];
        System.arraycopy(iv, 0, ciphertext, 0, 16);
        System.arraycopy(ciphertextBuffer, 0, ciphertext, 16, ciphertextLen[0]);
        return ciphertext;
    }

    public static byte[] sm4CbcDecryptWithMac(byte[] encKey, byte[] macKey, byte[] ciphertext) {
        MyCryptoStatus.checkState(ciphertext.length >= 48, "invalid MyCryptoStatus: " + (Object)((Object)MyCryptoStatus.getStatusByCode(-16385)));
        byte[] iv = new byte[16];
        byte[] ciphertextBuffer = new byte[ciphertext.length - 16];
        System.arraycopy(ciphertext, 0, iv, 0, 16);
        System.arraycopy(ciphertext, 16, ciphertextBuffer, 0, ciphertext.length - 16);
        int[] plaintextBufferLen = new int[]{ciphertext.length - 16};
        byte[] plaintextBuffer = new byte[plaintextBufferLen[0]];
        int ret = LoadNativeMyCrypto.sm4CbcDecryptWithMacNative(encKey, macKey, iv, ciphertextBuffer, ciphertextBuffer.length, plaintextBuffer, plaintextBufferLen);
        MyCryptoStatus status = MyCryptoStatus.getStatusByCode(ret);
        MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus: " + (Object)((Object)status));
        byte[] plaintext = new byte[plaintextBufferLen[0]];
        System.arraycopy(plaintextBuffer, 0, plaintext, 0, plaintextBufferLen[0]);
        return plaintext;
    }
}

