/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.keyoperator;

import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keyoperator.KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.NumericUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public class Pkcs8KeyOperator
implements KeyOperator {
    public Pkcs8KeyOperator() {
        CryptoUtils.initMaxKeySize();
    }

    @Override
    public Keypair generate(KeyTypeEnum type) {
        Keypair keypair = null;
        try {
            switch (type) {
                case KEY_ECCK1_PKCS8: 
                case KEY_SM2_PKCS8: 
                case KEY_ECCR1_PKCS8: {
                    keypair = this.generateEccKeyPair(type);
                    break;
                }
                case KEY_RSA2048_PKCS8: {
                    keypair = this.generateRSAKeyPair(2048);
                    break;
                }
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        return keypair;
    }

    @Override
    public Keypair loadFromPrivkey(byte[] privkeyEncoded) {
        byte[] prikey;
        KeyTypeEnum type;
        if (ArrayUtils.isEmpty((byte[])privkeyEncoded)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "privkeyEncoded should not empty");
        }
        if (privkeyEncoded.length <= 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "privkeyEncoded is too short");
        }
        if (privkeyEncoded.length == 32) {
            type = KeyTypeEnum.KEY_ECCK1_PKCS8;
            prikey = privkeyEncoded;
        } else {
            type = KeyTypeEnum.valueOf(privkeyEncoded);
            prikey = Arrays.copyOfRange((byte[])privkeyEncoded, (int)2, (int)privkeyEncoded.length);
        }
        switch (type) {
            case KEY_ECCK1_PKCS8: {
                BigInteger d = new BigInteger(1, prikey);
                return this.eccPrivateKey2Keypair(type, "secp256k1", d);
            }
            case KEY_SM2_PKCS8: {
                BigInteger d = new BigInteger(1, prikey);
                return this.eccPrivateKey2Keypair(type, "sm2p256v1", d);
            }
            case KEY_RSA2048_PKCS8: {
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(prikey);
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
                    RSAPrivateCrtKeyImpl rsaPrivateKey = (RSAPrivateCrtKeyImpl)privateK;
                    return this.rsaPrivateKey2Keypair(rsaPrivateKey);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (InvalidKeySpecException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
                catch (InvalidKeyException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return null;
    }

    @Override
    public Keypair load(String path, String password) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            Keypair keypair = this.loadKey(inputStream, password);
            return keypair;
        }
        catch (FileNotFoundException e) {
            throw new MychainSdkException(ErrorCode.SDK_GET_FILE_INPUT_STREAM_FAILED, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public Keypair load(byte[] keyBytes, String password) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(keyBytes);
            Keypair keypair = this.loadKey(inputStream, password);
            return keypair;
        }
        catch (OperatorCreationException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (PKCSException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public Keypair loadPubkey(String path) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            Keypair keypair = this.loadPubkey(inputStream);
            return keypair;
        }
        catch (FileNotFoundException e) {
            throw new MychainSdkException(ErrorCode.SDK_GET_FILE_INPUT_STREAM_FAILED, e.getMessage());
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public Keypair loadPubkey(byte[] pubkeyBytes) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(pubkeyBytes);
            Keypair keypair = this.loadPubkey(inputStream);
            return keypair;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public Keypair loadFromPubkey(byte[] pubkeyBytes) {
        return new Keypair(pubkeyBytes);
    }

    @Override
    public boolean save(Keypair key, String path, String password) {
        try {
            switch (key.getType()) {
                case KEY_ECCK1_PKCS8: 
                case KEY_SM2_PKCS8: {
                    PrivateKey privateKey = this.getEcPrivateKey(key);
                    if (privateKey == null) break;
                    return this.saveFile(path, privateKey, password == null ? null : password.toCharArray());
                }
                case KEY_RSA2048_PKCS8: {
                    PrivateKey privateKey = this.getRSAPrivateKey(key);
                    if (privateKey == null) break;
                    return this.saveFile(path, privateKey, password == null ? null : password.toCharArray());
                }
            }
        }
        catch (InvalidKeySpecException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (OperatorCreationException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        return false;
    }

    private Keypair loadKey(InputStream inputStream, String password) throws IOException, OperatorCreationException, PKCSException, InvalidKeyException {
        PrivateKey privateKey = this.getPrivateKeyFromPKCS8(inputStream, password);
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)privateKey;
            String curveName = ((ECNamedCurveSpec)bcecPrivateKey.getParams()).getName();
            BigInteger d = bcecPrivateKey.getD();
            switch (curveName) {
                case "secp256k1": {
                    return this.eccPrivateKey2Keypair(KeyTypeEnum.KEY_ECCK1_PKCS8, curveName, d);
                }
                case "sm2p256v1": {
                    return this.eccPrivateKey2Keypair(KeyTypeEnum.KEY_SM2_PKCS8, curveName, d);
                }
            }
        } else if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateCrtKeyImpl rsaPrivateKey = (RSAPrivateCrtKeyImpl)privateKey;
            return this.rsaPrivateKey2Keypair(rsaPrivateKey);
        }
        return null;
    }

    private Keypair loadPubkey(InputStream inputStream) throws IOException {
        PublicKey publicKey = this.getPublicKeyFromPKCS8(inputStream);
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey bcecPublicKey = (BCECPublicKey)publicKey;
            String curveName = ((ECNamedCurveSpec)bcecPublicKey.getParams()).getName();
            byte[] pubkeyId = bcecPublicKey.getQ().getEncoded(false);
            switch (curveName) {
                case "secp256k1": {
                    byte[] typeBytes = KeyTypeEnum.KEY_ECCK1_PKCS8.toBytes();
                    byte[] pubkeyEncoded = new byte[2 + pubkeyId.length];
                    System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
                    System.arraycopy(pubkeyId, 0, pubkeyEncoded, 2, pubkeyId.length);
                    return new Keypair(pubkeyEncoded);
                }
                case "sm2p256v1": {
                    byte[] typeBytes = KeyTypeEnum.KEY_SM2_PKCS8.toBytes();
                    byte[] pubkeyEncoded = new byte[2 + pubkeyId.length];
                    System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
                    System.arraycopy(pubkeyId, 0, pubkeyEncoded, 2, pubkeyId.length);
                    return new Keypair(pubkeyEncoded);
                }
            }
        } else if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            byte[] pubkeyId = rsaPublicKey.getEncoded();
            byte[] typeBytes = KeyTypeEnum.KEY_RSA2048_PKCS8.toBytes();
            byte[] pubkeyEncoded = new byte[2 + pubkeyId.length];
            System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
            System.arraycopy(pubkeyId, 0, pubkeyEncoded, 2, pubkeyId.length);
            return new Keypair(pubkeyEncoded);
        }
        return null;
    }

    private Keypair generateEccKeyPair(KeyTypeEnum type) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        switch (type) {
            case KEY_ECCK1_PKCS8: {
                KeyPair securityKeyPair = this.generateEccKeyPair("ECDSA", "secp256k1");
                BigInteger d = ((BCECPrivateKey)securityKeyPair.getPrivate()).getD();
                return this.eccPrivateKey2Keypair(type, "secp256k1", d);
            }
            case KEY_SM2_PKCS8: {
                KeyPair securityKeyPair = this.generateEccKeyPair("ECDSA", "sm2p256v1");
                BigInteger d = ((BCECPrivateKey)securityKeyPair.getPrivate()).getD();
                return this.eccPrivateKey2Keypair(type, "sm2p256v1", d);
            }
            case KEY_ECCR1_PKCS8: {
                KeyPair securityKeyPair = this.generateEccKeyPair("ECDSA", "secp256r1");
                BigInteger d = ((BCECPrivateKey)securityKeyPair.getPrivate()).getD();
                return this.eccPrivateKey2Keypair(type, "secp256r1", d);
            }
        }
        return null;
    }

    private KeyPair generateEccKeyPair(String algorithm, String curveName) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm, "BC");
        generator.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        return generator.generateKeyPair();
    }

    private Keypair generateRSAKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(keysize, new SecureRandom());
        KeyPair securityKeyPair = keyPairGen.generateKeyPair();
        byte[] pubkeyId = securityKeyPair.getPublic().getEncoded();
        byte[] privkeyId = securityKeyPair.getPrivate().getEncoded();
        byte[] typeBytes = KeyTypeEnum.KEY_RSA2048_PKCS8.toBytes();
        byte[] pubkeyEncoded = new byte[2 + pubkeyId.length];
        System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
        System.arraycopy(pubkeyId, 0, pubkeyEncoded, 2, pubkeyId.length);
        byte[] privkeyEncoded = new byte[2 + privkeyId.length];
        System.arraycopy(typeBytes, 0, privkeyEncoded, 0, 2);
        System.arraycopy(privkeyId, 0, privkeyEncoded, 2, privkeyId.length);
        return new Keypair(pubkeyEncoded, privkeyEncoded);
    }

    private PrivateKey getPrivateKeyFromPKCS8(InputStream privkeyInputStream, String password) throws PKCSException, IOException, OperatorCreationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(privkeyInputStream));
        PKCS8EncryptedPrivateKeyInfo pair = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
        JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder();
        jce.setProvider("BC");
        InputDecryptorProvider decProv = jce.build(password == null ? null : password.toCharArray());
        PrivateKeyInfo info = pair.decryptPrivateKeyInfo(decProv);
        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
        return pemKeyConverter.getPrivateKey(info);
    }

    private PublicKey getPublicKeyFromPKCS8(InputStream inputStream) throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(inputStream));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        Object obj = parser.readObject();
        parser.close();
        return converter.getPublicKey((SubjectPublicKeyInfo)obj);
    }

    private PrivateKey getEcPrivateKey(Keypair keypair) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        String curveName;
        String algorithm;
        switch (keypair.getType()) {
            case KEY_ECCK1_PKCS8: {
                algorithm = "ECDSA";
                curveName = "secp256k1";
                break;
            }
            case KEY_SM2_PKCS8: {
                algorithm = "ECDSA";
                curveName = "sm2p256v1";
                break;
            }
            default: {
                return null;
            }
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        ECNamedCurveSpec spec = new ECNamedCurveSpec(curveName, parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(new BigInteger(1, keypair.getPrivkeyId()), (ECParameterSpec)spec);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, "BC");
        return keyFactory.generatePrivate(keySpec);
    }

    private PrivateKey getRSAPrivateKey(Keypair keypair) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keypair.getPrivkeyId());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        return privateK;
    }

    private boolean saveFile(String filePath, PrivateKey privateKey, char[] password) throws IOException, OperatorCreationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_3DES);
        encryptorBuilder.setProvider("BC");
        encryptorBuilder.setPasssword(password);
        OutputEncryptor encryptor = encryptorBuilder.build();
        JcaPKCS8Generator gen2 = new JcaPKCS8Generator(privateKey, encryptor);
        PemObject obj2 = gen2.generate();
        StringWriter sw2 = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw2);){
            pw.writeObject((PemObjectGenerator)obj2);
        }
        String pkcs8Key2 = sw2.toString();
        FileOutputStream fos2 = new FileOutputStream(filePath);
        fos2.write(pkcs8Key2.getBytes());
        fos2.flush();
        fos2.close();
        return true;
    }

    private Keypair eccPrivateKey2Keypair(KeyTypeEnum keyTypeEnum, String curveName, BigInteger d) {
        byte[] typeBytes = keyTypeEnum.toBytes();
        byte[] privkeyId = NumericUtils.toBytesPadded(d, 32);
        byte[] privkeyEncoded = new byte[34];
        System.arraycopy(typeBytes, 0, privkeyEncoded, 0, 2);
        System.arraycopy(privkeyId, 0, privkeyEncoded, 2, privkeyId.length);
        byte[] pubKeyId = CryptoUtils.publicPointFromPrivate(curveName, d).getEncoded(false);
        byte[] pubkeyEncoded = new byte[2 + pubKeyId.length];
        System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
        System.arraycopy(pubKeyId, 0, pubkeyEncoded, 2, pubKeyId.length);
        return new Keypair(pubkeyEncoded, privkeyEncoded);
    }

    private Keypair rsaPrivateKey2Keypair(RSAPrivateCrtKeyImpl rsaPrivateKey) throws InvalidKeyException {
        BigInteger n = rsaPrivateKey.getModulus();
        BigInteger e = rsaPrivateKey.getPublicExponent();
        RSAPublicKeyImpl rsaPublicKey = new RSAPublicKeyImpl(n, e);
        byte[] typeBytes = KeyTypeEnum.KEY_RSA2048_PKCS8.toBytes();
        byte[] pubkeyId = rsaPublicKey.getEncoded();
        byte[] privkeyId = rsaPrivateKey.getEncoded();
        byte[] pubkeyEncoded = new byte[2 + pubkeyId.length];
        System.arraycopy(typeBytes, 0, pubkeyEncoded, 0, 2);
        System.arraycopy(pubkeyId, 0, pubkeyEncoded, 2, pubkeyId.length);
        byte[] privkeyEncoded = new byte[2 + privkeyId.length];
        System.arraycopy(typeBytes, 0, privkeyEncoded, 0, 2);
        System.arraycopy(privkeyId, 0, privkeyEncoded, 2, privkeyId.length);
        return new Keypair(pubkeyEncoded, privkeyEncoded);
    }
}

