/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.pkeycipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import sun.security.rsa.RSAPublicKeyImpl;

public class RSAPkeyCipherV1
implements PkeyCipherBase {
    private static final int RSA2048_KEY_LEN = 256;
    private static final int OAEP_HASH_LEN = 32;
    private static final int MAX_MESSAGE_LEN = 190;
    private byte[] privateKey;
    private byte[] publicKey;

    public RSAPkeyCipherV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isDecryptor() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        if (ArrayUtils.isEmpty((byte[])plainText)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText is empty");
        }
        if (plainText.length > 190) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText size more than 190!");
        }
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        try {
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA", "BC");
            X509EncodedKeySpec rsaPubkeySpec1 = new X509EncodedKeySpec(this.publicKey);
            RSAPublicKey rsaCipherPubkey = (RSAPublicKey)rsaKeyFactory.generatePublic(rsaPubkeySpec1);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", "BC");
            rsaCipher.init(1, rsaCipherPubkey);
            byte[] rawCipher = rsaCipher.doFinal(plainText);
            byte[] output = new byte[262];
            System.arraycopy(this.getAlgo().toBytes(), 0, output, 0, 2);
            byte[] pubkeyWithAlgo = new byte[2 + this.publicKey.length];
            System.arraycopy(KeyTypeEnum.KEY_RSA2048_PKCS8.toBytes(), 0, pubkeyWithAlgo, 0, 2);
            System.arraycopy(this.publicKey, 0, pubkeyWithAlgo, 2, this.publicKey.length);
            System.arraycopy(CryptoUtils.getPubkeyFp(pubkeyWithAlgo), 0, output, 2, 4);
            System.arraycopy(rawCipher, 0, output, 6, rawCipher.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "no private key");
        }
        if (ciphertext.length < 256) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "cipher text length is too short");
        }
        try {
            byte[] rawCipherText = new byte[ciphertext.length - 6];
            System.arraycopy(ciphertext, 6, rawCipherText, 0, rawCipherText.length);
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA", "BC");
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(this.privateKey);
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)rsaKeyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", "BC");
            cipher.init(2, rsaPrivateCrtKey);
            return cipher.doFinal(rawCipherText);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKey privateK = (RSAPrivateCrtKey)keyFactory.generatePrivate(pkcs8KeySpec);
            RSAPublicKeyImpl rsaPublicKey = new RSAPublicKeyImpl(privateK.getModulus(), privateK.getPublicExponent());
            return rsaPublicKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeySpecException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "priKey is invalid :: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Keypair keypair = new Keypair(Hex.decode((String)"000430820122300d06092a864886f70d01010105000382010f003082010a0282010100c727186ee5aab800c7ad32c056c0c1c67fd090a093b2f9a972fbed77be56e730871c7c49ac9915ba8bda03b1f692f35f94517083df652c06f4b55d2b27600dfca942998b869138b3988af5bfaa18850fcc90b78087df66f0d93548ea3e103ee9ed1825156ebf0d059904aeaeb88336ee0283dbe46a67d9b7d267e4c9e1707e280d760b1bbb5c95491f0a7393682e0bed5b33b4995989d497a123c60525bbfaff0129a8f8c64473b8ad09aa67ff966b8eda267a77447c975301a1b576539049643bd1a3fbe42f516a475a011b0fa6b9c2669c79150cac3a9542eaef0e1157b5466db0a4345ac5a97dd5b618017046b936ccd5f4af85f669a1aece4546f5ddef6d0203010001"), Hex.decode((String)"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"));
        RSAPkeyCipherV1 rsaPkeyCipherV1 = new RSAPkeyCipherV1(keypair);
        System.out.println(new String(Hex.decode((String)"48656c6c6f20776f726c6421")));
        byte[] cipherText = rsaPkeyCipherV1.encrypt(Hex.decode((String)"48656c6c6f20776f726c6421"));
        System.out.println(Hex.toHexString((byte[])cipherText));
        byte[] text = rsaPkeyCipherV1.decrypt(Hex.decode((String)"006732eeebdaae5d7ee3af928999b0f859d92762797b964cb322c70e19a9952a9ee39b30d0ce278b1a986470843b41edde92db1cc933c4aaba40521f74ef41897b7f5074840a6f934c54035a790a840e5ad6c6141153a583cb35b486d95dbd22313a759921851dcf08e70a846aa52e2761246b335f96762965220d19a44ce72b6a2ecaf7ec0d4c1a6dfc97ef728e24c2dbfc97922c4c101a2e03a7faa6f650b5e557f539ca591ddacef28c2f2a1d4bcc720a3df4ad04501236afafe57157848558f3f682d44c2e9e10f4f19c5de94407164d5caeb1c70736fff524d2eb979644fbb1262eaa82f4607a4edd2c7626f1c5dec7b92db14430ed4766803c02569fa2541edd2c1e54"));
        System.out.println(new String(text));
    }
}

