/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.privacy;

import com.alipay.mychain.sdk.domain.privacy.EncResult;
import com.alipay.mychain.sdk.domain.privacy.PedersenCommitmentType;
import com.alipay.mychain.sdk.domain.privacy.ValueHiding;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class PedersenCommitment {
    private PedersenCommitmentType type = PedersenCommitmentType.DEFAULT_TYPE;
    private long ptr = 0L;

    public PedersenCommitment(long ptr) {
        this.ptr = ptr;
    }

    public static native byte[] genBlind();

    public static PedersenCommitment createCommitment(long value, byte[] blind, ValueHiding keypair, byte[] extensions) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be greater equals than 0!");
        }
        if (ArrayUtils.isEmpty((byte[])blind)) {
            throw new IllegalArgumentException("blind is not empty!");
        }
        return new PedersenCommitment(PedersenCommitment.nativeCreateCommitment(value, blind, keypair.getPtr(), extensions));
    }

    public static PedersenCommitment createCommitment(byte[] commitment) {
        return new PedersenCommitment(PedersenCommitment.nativeCreateCommitment(commitment));
    }

    private static native long nativeCreateCommitment(long var0, byte[] var2, long var3, byte[] var5);

    public static native long nativeCreateCommitment(byte[] var0);

    public static long getDecryptedValue(byte[] commitment, ValueHiding keypair) {
        return PedersenCommitment.getDecryptedValue(commitment, keypair.getPtr());
    }

    private static native long getDecryptedValue(byte[] var0, long var1);

    public static byte[] getDecryptedBlind(byte[] commitment, ValueHiding keypair) {
        return PedersenCommitment.getDecryptedBlind(commitment, keypair.getPtr());
    }

    private static native byte[] getDecryptedBlind(byte[] var0, long var1);

    public static boolean isSumEqualsToZero(List<PedersenCommitment> pos, List<PedersenCommitment> neg, byte[] delta) {
        ArrayList<Long> posPtrList = new ArrayList<Long>();
        for (PedersenCommitment item : pos) {
            posPtrList.add(item.getPtr());
        }
        ArrayList<Long> negPtrList = new ArrayList<Long>();
        for (PedersenCommitment item : neg) {
            negPtrList.add(item.getPtr());
        }
        return PedersenCommitment.nativeIsSumEqualsToZero(ArrayUtils.toPrimitive((Long[])posPtrList.toArray(new Long[posPtrList.size()])), ArrayUtils.toPrimitive((Long[])negPtrList.toArray(new Long[negPtrList.size()])), delta);
    }

    private static native boolean nativeIsSumEqualsToZero(long[] var0, long[] var1, byte[] var2);

    public static byte[] computeBlindDelta(List<byte[]> inputs, List<byte[]> outputs) {
        byte[][] inputArray = new byte[inputs.size()][];
        for (int i = 0; i < inputs.size(); ++i) {
            inputArray[i] = inputs.get(i);
        }
        byte[][] outArray = new byte[outputs.size()][];
        for (int i = 0; i < outputs.size(); ++i) {
            outArray[i] = outputs.get(i);
        }
        return PedersenCommitment.nativeComputeBlindDelta(inputArray, outArray);
    }

    private static native byte[] nativeComputeBlindDelta(byte[][] var0, byte[][] var1);

    public void destory() {
        if (this.ptr != 0L) {
            this.destoryInstance(this.ptr);
            this.ptr = 0L;
        }
    }

    private native long nativeNewInstance();

    private native long destoryInstance(long var1);

    public boolean verify(byte[] pub, PedersenCommitment commitment) {
        return this.nativeVerify(pub, commitment.getPtr());
    }

    private native boolean nativeVerify(byte[] var1, long var2);

    public long getDecryptedValue(ValueHiding keypair) {
        return this.nativeGetDecryptedValue(keypair.getPtr());
    }

    private native long nativeGetDecryptedValue(long var1);

    public final byte[] getDecryptedBlind(ValueHiding keypair) {
        return this.nativeGetDecryptedBlind(keypair.getPtr());
    }

    private native byte[] nativeGetDecryptedBlind(long var1);

    public EncResult getEncValue() {
        return new EncResult(this.nativeGetEncValue());
    }

    private native byte[] nativeGetEncValue();

    public final byte[] getCommitment() {
        return this.nativeGetCommitment();
    }

    private native byte[] nativeGetCommitment();

    private native byte[] nativeToBytes();

    public final byte[] toBytes() {
        return this.nativeToBytes();
    }

    public long getPtr() {
        return this.ptr;
    }
}

