/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryRelatedTransactionListRequest
extends Request {
    private Identity receiverId;
    private long depositFlag = 0L;
    private long startIndex = 0L;
    private int size = 0;

    public QueryRelatedTransactionListRequest(Identity receiverId, long depositFlag, long startIndex, int size) {
        super(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST);
        this.receiverId = receiverId;
        this.depositFlag = depositFlag;
        this.startIndex = startIndex;
        this.size = size;
    }

    public QueryRelatedTransactionListRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST);
    }

    public Identity getReceiverId() {
        return this.receiverId;
    }

    public long getDepositFlag() {
        return this.depositFlag;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.receiverId != null && !this.receiverId.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) && this.depositFlag >= 0L && this.startIndex >= 0L && this.size >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] txReceiverIdBytes = Rlp.encodeElement(this.receiverId.getValue());
        byte[] depositFlagBytes = Rlp.encodeLong(this.depositFlag);
        byte[] startIndexBytes = Rlp.encodeLong(this.startIndex);
        byte[] sizeBytes = Rlp.encodeInt(this.size);
        return Rlp.encodeList(super.toRlp(), txReceiverIdBytes, depositFlagBytes, startIndexBytes, sizeBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.receiverId = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.depositFlag = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.startIndex = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.size = ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("receiver_id", (Object)ByteUtils.toHexString(this.receiverId.getValue()));
        jsonObject.put("deposit_flag", (Object)this.depositFlag);
        jsonObject.put("start_index", (Object)this.startIndex);
        jsonObject.put("size", (Object)this.size);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.receiverId = new Identity(jsonObject.getString("receiver_id"));
        this.depositFlag = jsonObject.getLongValue("deposit_flag");
        this.startIndex = jsonObject.getLongValue("start_index");
        this.size = jsonObject.getIntValue("size");
    }
}

