/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryRelatedTransactionListSizeRequest
extends Request {
    private Identity receiverId;
    private long depositFlag = 0L;

    public QueryRelatedTransactionListSizeRequest(Identity receiverId, long depositFlag) {
        super(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST_SIZE);
        this.receiverId = receiverId;
        this.depositFlag = depositFlag;
    }

    public QueryRelatedTransactionListSizeRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST_SIZE);
    }

    public Identity getReceiverId() {
        return this.receiverId;
    }

    public long getDepositFlag() {
        return this.depositFlag;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.receiverId != null && !this.receiverId.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) && this.depositFlag >= 0L;
    }

    @Override
    public byte[] toRlp() {
        byte[] txReceiverIdBytes = Rlp.encodeElement(this.receiverId.getValue());
        byte[] depositFlagBytes = Rlp.encodeLong(this.depositFlag);
        return Rlp.encodeList(super.toRlp(), txReceiverIdBytes, depositFlagBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.receiverId = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.depositFlag = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("receiver_id", (Object)ByteUtils.toHexString(this.receiverId.getValue()));
        jsonObject.put("deposit_flag", (Object)this.depositFlag);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.receiverId = new Identity(jsonObject.getString("receiver_id"));
        this.depositFlag = jsonObject.getLongValue("deposit_flag");
    }
}

