/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.transaction.TransactionInfo;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryTransactionAndReceiptResponse
extends Response {
    private List<TransactionInfo> infos;

    public QueryTransactionAndReceiptResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_TX_AND_RECEIPT);
    }

    public QueryTransactionAndReceiptResponse(List<TransactionInfo> transactionInfoList) {
        super(MessageType.MSG_TYPE_QUERY_RESP_TX_AND_RECEIPT);
        this.infos = transactionInfoList;
    }

    public List<TransactionInfo> getTransactionInfos() {
        return this.infos;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (TransactionInfo item : this.infos) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.infos = new ArrayList<TransactionInfo>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            TransactionInfo item = new TransactionInfo();
            item.fromRlp((RlpList)element);
            this.infos.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.infos != null) {
            for (TransactionInfo item : this.infos) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("transaction_infos", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.infos = new ArrayList<TransactionInfo>();
        JSONArray jsonArray = jsonObject.getJSONArray("transaction_infos");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                TransactionInfo object = new TransactionInfo();
                object.fromJson((JSONObject)iterator.next());
                this.infos.add(object);
            }
        }
    }
}

