/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryReceiptProofRequest
extends Request {
    private Hash transactionHash = new Hash();

    public QueryReceiptProofRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_RECEIPT_PROOF);
    }

    public QueryReceiptProofRequest(Hash transactionHash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_RECEIPT_PROOF);
        this.transactionHash = transactionHash;
    }

    public Hash getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(Hash transactionHash) {
        this.transactionHash = transactionHash;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.transactionHash != null && !this.transactionHash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue());
    }

    @Override
    public byte[] toRlp() {
        byte[] blockHashBytes = Rlp.encodeElement(this.transactionHash.getValue());
        return Rlp.encodeList(super.toRlp(), blockHashBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.transactionHash = new Hash(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.transactionHash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transactionHash = new Hash(jsonObject.getString("hash"));
    }
}

