/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryStateProofRequest
extends Request {
    private Identity id = new Identity();
    private BigInteger blockNumber = BigInteger.ZERO;
    private Hash hash = new Hash();

    public QueryStateProofRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_STATE_PROOF);
    }

    public QueryStateProofRequest(Identity id, BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_REQ_STATE_PROOF);
        this.id = id;
        this.blockNumber = blockNumber;
    }

    public QueryStateProofRequest(Identity id, Hash hash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_STATE_PROOF);
        this.id = id;
        this.hash = hash;
    }

    public QueryStateProofRequest(Identity id, BigInteger blockNumber, Hash hash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_STATE_PROOF);
        this.id = id;
        this.blockNumber = blockNumber;
        this.hash = hash;
    }

    public Hash getId() {
        return this.id;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public Hash getHash() {
        return this.hash;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.blockNumber != null && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] idBytes = Rlp.encodeElement(this.id.getValue());
        byte[] blockBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] hashBytes = Rlp.encodeElement(this.hash.getValue());
        return Rlp.encodeList(super.toRlp(), idBytes, blockBytes, hashBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
        this.hash = new Hash(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.id.getValue()));
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = new Identity(jsonObject.getString("id"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.hash = new Hash(jsonObject.getString("hash"));
    }
}

