/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryNodeMetricsStatusRequest
extends Request {
    private Hash hash = new Hash();
    private long startTime = 0L;
    private long endTime = 0L;

    public QueryNodeMetricsStatusRequest() {
        super(MessageType.MSG_TYPE_STATUS_REQ_ACC_TX_METRICS);
    }

    public QueryNodeMetricsStatusRequest(long startTime, long endTime) {
        super(MessageType.MSG_TYPE_STATUS_REQ_ACC_TX_METRICS);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public QueryNodeMetricsStatusRequest(long startTime, long endTime, Hash hash) {
        super(MessageType.MSG_TYPE_STATUS_REQ_ACC_TX_METRICS);
        this.hash = hash;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.hash != null && (this.endTime > this.startTime || this.endTime == this.startTime && this.startTime == 0L);
    }

    @Override
    public byte[] toRlp() {
        byte[] node_id = Rlp.encodeElement(this.hash.getValue());
        byte[] start_time = Rlp.encodeLong(this.startTime);
        byte[] end_time = Rlp.encodeLong(this.endTime);
        return Rlp.encodeList(super.toRlp(), node_id, start_time, end_time);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.hash = new Hash(((RlpElement)list.get(1)).getRlpData());
        this.startTime = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.endTime = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("node_id", (Object)ByteUtils.toHexString(this.hash.getValue()));
        jsonObject.put("start_time", (Object)this.startTime);
        jsonObject.put("end_time", (Object)this.endTime);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.hash = new Hash(jsonObject.getString("node_id"));
        this.startTime = jsonObject.getLong("start_time");
        this.endTime = jsonObject.getLong("end_time");
    }
}

