/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.envelope;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class JoinGroupRequest
extends Request {
    private byte[] groupPrivateKey;
    private PublicKey anonymousPublicKey;
    private Identity from;

    public JoinGroupRequest(byte[] groupPrivateKey, PublicKey anonymousPublicKey, BaseFixedSizeByteArray.Fixed20ByteArray groupId, Identity from) {
        super(MessageType.MSG_TYPE_TX_REQ_JOIN_GROUP);
        this.groupPrivateKey = groupPrivateKey;
        this.anonymousPublicKey = anonymousPublicKey;
        this.from = from;
        this.groupId = groupId;
    }

    public JoinGroupRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_JOIN_GROUP);
    }

    public byte[] getGroupPrivateKey() {
        return this.groupPrivateKey;
    }

    public PublicKey getAnonymousPublicKey() {
        return this.anonymousPublicKey;
    }

    public Identity getFrom() {
        return this.from;
    }

    public void setFrom(Identity from) {
        this.from = from;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.from != null && !this.from.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.anonymousPublicKey != null && this.groupPrivateKey != null;
    }

    @Override
    public byte[] toRlp() {
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] publicKeyBytes = Rlp.encodeElement(this.anonymousPublicKey.getValue());
        byte[] groupPrivateKeyBytes = Rlp.encodeElement(this.groupPrivateKey);
        return Rlp.encodeList(super.toRlp(), fromBytes, publicKeyBytes, groupPrivateKeyBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp(list);
        this.from = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.anonymousPublicKey = new PublicKey(((RlpElement)list.get(2)).getRlpData());
        this.groupPrivateKey = ((RlpElement)list.get(3)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("from", (Object)ByteUtils.toHexString(this.from.getValue()));
        jsonObject.put("anonymous_public_key", (Object)ByteUtils.toHexString(this.anonymousPublicKey.getValue()));
        jsonObject.put("group_private_key", (Object)ByteUtils.toHexString(this.groupPrivateKey));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.from = new Identity(jsonObject.getString("from"));
        this.anonymousPublicKey = new PublicKey(ByteUtils.hexStringToBytes(jsonObject.getString("anonymous_public_key")));
        this.groupPrivateKey = ByteUtils.hexStringToBytes(jsonObject.getString("group_private_key"));
    }
}

