/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.query.QueryHeartBeatRequest;
import com.alipay.mychain.sdk.network.ChannelStatus;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import java.util.concurrent.atomic.AtomicInteger;

public class HeartBeatTask
extends AbstractTask {
    private INetwork network;
    private Integer heartBeatIntervalMs = 30000;
    private int retryTimes = 3;
    private AtomicInteger failedTimes = new AtomicInteger(0);

    public HeartBeatTask(INetwork network, ILogger logger, Integer heartBeatIntervalMs, int retryTimes) {
        super(heartBeatIntervalMs, TaskType.ALWAYS, logger);
        this.heartBeatIntervalMs = heartBeatIntervalMs;
        this.network = network;
        this.retryTimes = retryTimes;
    }

    @Override
    public void run() {
        if (this.network == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.logger.debug("parameters check currentTime = {},lastResponseTime ={}, heartbeatIntervalMs ={},currentTime-lastResponseTime ={}", currentTime, this.network.getLastActiveTime(), this.heartBeatIntervalMs, currentTime - this.network.getLastActiveTime());
        if (this.heartBeatIntervalMs > 0 && currentTime - this.network.getLastActiveTime() > (long)this.heartBeatIntervalMs.intValue()) {
            this.network.sendAsyncRequest(new QueryHeartBeatRequest(), new Hash(), new IAsyncCallback(){

                @Override
                public void onResponse(int errorCode, Response response) {
                    if (response.isSuccess()) {
                        HeartBeatTask.this.logger.debug("sendHeartBeat response true, heartBeatUnSuccessTimes:{}", (Object)HeartBeatTask.this.failedTimes.get());
                        HeartBeatTask.this.failedTimes.set(0);
                    } else {
                        int times = HeartBeatTask.this.failedTimes.incrementAndGet();
                        HeartBeatTask.this.logger.warn("sendHeartBeat response false, heartBeatUnSuccessTimes:{}", (Object)times);
                    }
                    if (HeartBeatTask.this.failedTimes.get() >= HeartBeatTask.this.retryTimes) {
                        HeartBeatTask.this.network.checkAndSetStatus(ChannelStatus.DISCONNECTED);
                    }
                }
            }, this.heartBeatIntervalMs);
        }
    }
}

