/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.type;

import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.Arrays;

public abstract class BaseFixedSizeByteArray {
    protected byte[] data;

    protected abstract int getBitSize();

    protected void checkValid(byte[] bytes) {
        if (bytes.length > this.getBitSize()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, String.format("size{%d} is larger than max{%d}", bytes.length, this.getBitSize()));
        }
    }

    protected void fillInData(byte[] bytes) {
        this.data = new byte[this.getBitSize()];
        for (int i = 0; i < bytes.length; ++i) {
            if (i >= bytes.length) continue;
            this.data[this.getBitSize() - 1 - i] = bytes[bytes.length - 1 - i];
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BaseFixedSizeByteArray{");
        sb.append("data=").append(Arrays.toString(this.data));
        sb.append('}');
        return sb.toString();
    }

    public static class Fixed20ByteArray
    extends BaseFixedSizeByteArray {
        public static Fixed20ByteArray valueOf(byte[] bytes) {
            Fixed20ByteArray byteArray = new Fixed20ByteArray();
            byteArray.checkValid(bytes);
            byteArray.fillInData(bytes);
            return byteArray;
        }

        public static Fixed20ByteArray valueOf(String hexString) {
            byte[] bytes = ByteUtils.hexStringToBytes(hexString);
            return Fixed20ByteArray.valueOf(bytes);
        }

        public static Fixed20ByteArray defaultValue() {
            Fixed20ByteArray byteArray = new Fixed20ByteArray();
            byte[] bytes = new byte[20];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = 0;
            }
            byteArray.fillInData(bytes);
            return byteArray;
        }

        @Override
        protected int getBitSize() {
            return 20;
        }
    }

    public static class Fixed64ByteArray
    extends BaseFixedSizeByteArray {
        public static Fixed64ByteArray valueOf(byte[] bytes) {
            Fixed64ByteArray byteArray = new Fixed64ByteArray();
            byteArray.checkValid(bytes);
            byteArray.fillInData(bytes);
            return byteArray;
        }

        public static Fixed64ByteArray valueOf(String hexString) {
            byte[] bytes = ByteUtils.hexStringToBytes(hexString);
            return Fixed64ByteArray.valueOf(bytes);
        }

        @Override
        protected int getBitSize() {
            return 64;
        }
    }

    public static class Fixed32ByteArray
    extends BaseFixedSizeByteArray {
        public static Fixed32ByteArray valueOf(byte[] bytes) {
            Fixed32ByteArray byteArray = new Fixed32ByteArray();
            byteArray.checkValid(bytes);
            byteArray.fillInData(bytes);
            return byteArray;
        }

        public static Fixed32ByteArray valueOf(String hexString) {
            byte[] bytes = ByteUtils.hexStringToBytes(hexString);
            return Fixed32ByteArray.valueOf(bytes);
        }

        @Override
        protected int getBitSize() {
            return 32;
        }
    }
}

