/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm;

import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.vm.abi.MyFunctionEncoder;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Int256;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint256;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EVMParameter
implements Parameters {
    private static final int MAX_N = 32;
    private static final int MIN_N = 1;
    private String methodSignature;
    private List<Type> inputParameters = new ArrayList<Type>();

    public EVMParameter() {
    }

    public EVMParameter(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    public EVMParameter addInt(BigInteger value) {
        this.inputParameters.add(new Int256(value));
        return this;
    }

    public EVMParameter addUint(BigInteger value) {
        this.inputParameters.add(new Uint256(value));
        return this;
    }

    public EVMParameter addBool(boolean value) {
        this.inputParameters.add(new Bool(value));
        return this;
    }

    public EVMParameter addIdentity(Hash hash) {
        this.addBytes32(hash.getValue());
        return this;
    }

    public EVMParameter addString(String value) {
        this.inputParameters.add(new Utf8String(value));
        return this;
    }

    public EVMParameter addBytes(byte[] value) {
        this.inputParameters.add(new DynamicBytes(value));
        return this;
    }

    public EVMParameter addBytes32(byte[] value) {
        if (null == value) {
            throw new IllegalArgumentException(" value length must not be null");
        }
        if (value.length != 32) {
            throw new IllegalArgumentException(" value length must be 32");
        }
        this.inputParameters.add(new Bytes32(value));
        return this;
    }

    @Deprecated
    public EVMParameter addBytesN(byte[] value) {
        if (null == value) {
            throw new IllegalArgumentException(" value length must not be null");
        }
        if (value.length != 32) {
            throw new IllegalArgumentException(" value length must be 32");
        }
        this.inputParameters.add(new Bytes32(value));
        return this;
    }

    public EVMParameter addBytes32Array(List<byte[]> bytes32Array) {
        if (CollectionUtils.isEmpty(bytes32Array)) {
            throw new IllegalArgumentException(" bytes32 array must not be null or empty");
        }
        this.inputParameters.add(new DynamicArray<Bytes32>(Utils.typeMap(bytes32Array, Bytes32.class)));
        return this;
    }

    public EVMParameter addIntArray(List<BigInteger> intValues) {
        this.inputParameters.add(new DynamicArray<Int256>(Utils.typeMap(intValues, Int256.class)));
        return this;
    }

    public EVMParameter addUintArray(List<BigInteger> uIntValues) {
        this.inputParameters.add(new DynamicArray<Uint256>(Utils.typeMap(uIntValues, Uint256.class)));
        return this;
    }

    public EVMParameter addBooleanArray(List<Boolean> booleans) {
        this.inputParameters.add(new DynamicArray<Bool>(Utils.typeMap(booleans, Bool.class)));
        return this;
    }

    public String getEncodedData() {
        if (StringUtils.isEmpty((CharSequence)this.methodSignature)) {
            return MyFunctionEncoder.encodeConstructor(this.inputParameters);
        }
        String methodId = MyFunctionEncoder.buildMethodId(this.methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return MyFunctionEncoder.encodeParameters(this.inputParameters, result);
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    @Override
    public byte[] getData() {
        return ByteUtils.hexStringToBytes(this.getEncodedData());
    }
}

