/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

import com.alipay.mychain.eInvoice.mycrypto.MycryptoCiphers;

public class EInvoiceMyCrypto {
    public byte[] encVerifyCode;
    public byte[] encPayerId;
    public byte[] encPayerName;
    public byte[] encEInvoiceXML;
    public byte[] encURL;

    public static EInvoiceMyCrypto encEInvoice(byte[] eInvoiceCode, byte[] eInvoiceNum, byte[] verifyCode, byte[] payerId, byte[] payerName, byte[] eInvoiceXML, byte[] url) {
        byte[] macKeyBuffer;
        byte[] encKeyBuffer;
        boolean hasPayerID;
        if (payerId != null) {
            hasPayerID = true;
        } else if (verifyCode != null) {
            hasPayerID = false;
        } else {
            throw new IllegalStateException("invalid MyCryptoStatus: (enc)Input verify code and payerID are both empty.");
        }
        if (eInvoiceCode == null || eInvoiceNum == null || verifyCode == null || payerName == null || eInvoiceXML == null || url == null) {
            throw new IllegalStateException("invalid MyCryptoStatus: (enc)eInvoiceCode/eInvoiceNum/verifyCode/payerName/eInvoiceXML/URL should not be empty.");
        }
        if (hasPayerID) {
            encKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + payerId.length + 1];
            macKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + payerId.length + 1];
            encKeyBuffer[0] = 1;
            macKeyBuffer[0] = 2;
            System.arraycopy(eInvoiceCode, 0, encKeyBuffer, 1, eInvoiceCode.length);
            System.arraycopy(eInvoiceNum, 0, encKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
            System.arraycopy(payerId, 0, encKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, payerId.length);
            System.arraycopy(eInvoiceCode, 0, macKeyBuffer, 1, eInvoiceCode.length);
            System.arraycopy(eInvoiceNum, 0, macKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
            System.arraycopy(payerId, 0, macKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, payerId.length);
        } else {
            encKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + verifyCode.length + 1];
            macKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + verifyCode.length + 1];
            encKeyBuffer[0] = 1;
            macKeyBuffer[0] = 2;
            System.arraycopy(eInvoiceCode, 0, encKeyBuffer, 1, eInvoiceCode.length);
            System.arraycopy(eInvoiceNum, 0, encKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
            System.arraycopy(verifyCode, 0, encKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, verifyCode.length);
            System.arraycopy(eInvoiceCode, 0, macKeyBuffer, 1, eInvoiceCode.length);
            System.arraycopy(eInvoiceNum, 0, macKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
            System.arraycopy(verifyCode, 0, macKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, verifyCode.length);
        }
        byte[] encKey = MycryptoCiphers.sm3KDF(encKeyBuffer, 16);
        byte[] macKey = MycryptoCiphers.sm3KDF(macKeyBuffer, 16);
        EInvoiceMyCrypto ret = new EInvoiceMyCrypto();
        ret.encVerifyCode = MycryptoCiphers.sm4CbcEncryptWithMac(encKey, macKey, verifyCode);
        ret.encPayerName = MycryptoCiphers.sm4CbcEncryptWithMac(encKey, macKey, payerName);
        ret.encEInvoiceXML = MycryptoCiphers.sm4CbcEncryptWithMac(encKey, macKey, eInvoiceXML);
        ret.encURL = MycryptoCiphers.sm4CbcEncryptWithMac(encKey, macKey, url);
        ret.encPayerId = (byte[])(hasPayerID ? MycryptoCiphers.sm4CbcEncryptWithMac(encKey, macKey, payerId) : null);
        return ret;
    }

    public static byte[] decEInvoice(byte[] eInvoiceCode, byte[] eInvoiceNum, byte[] verifyCode, byte[] payerId, byte[] ciphetext) {
        byte[] keyUsed;
        if (payerId != null) {
            keyUsed = payerId;
        } else if (verifyCode != null) {
            keyUsed = verifyCode;
        } else {
            throw new IllegalStateException("invalid MyCryptoStatus: (Dec)Input verify code and payerID are both empty.");
        }
        if (eInvoiceCode == null || eInvoiceNum == null || ciphetext == null) {
            throw new IllegalStateException("invalid MyCryptoStatus: (dec)eInvoiceCode/eInvoiceNum/ciphertext should not be empty.");
        }
        byte[] encKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + keyUsed.length + 1];
        byte[] macKeyBuffer = new byte[eInvoiceCode.length + eInvoiceNum.length + keyUsed.length + 1];
        encKeyBuffer[0] = 1;
        macKeyBuffer[0] = 2;
        System.arraycopy(eInvoiceCode, 0, encKeyBuffer, 1, eInvoiceCode.length);
        System.arraycopy(eInvoiceNum, 0, encKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
        System.arraycopy(keyUsed, 0, encKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, keyUsed.length);
        System.arraycopy(eInvoiceCode, 0, macKeyBuffer, 1, eInvoiceCode.length);
        System.arraycopy(eInvoiceNum, 0, macKeyBuffer, 1 + eInvoiceCode.length, eInvoiceNum.length);
        System.arraycopy(keyUsed, 0, macKeyBuffer, 1 + eInvoiceCode.length + eInvoiceNum.length, keyUsed.length);
        byte[] encKey = MycryptoCiphers.sm3KDF(encKeyBuffer, 16);
        byte[] macKey = MycryptoCiphers.sm3KDF(macKeyBuffer, 16);
        return MycryptoCiphers.sm4CbcDecryptWithMac(encKey, macKey, ciphetext);
    }

    public static byte[] deduceEInvoiceIndex(byte[] input) {
        if (input == null) {
            throw new IllegalStateException("invalid MyCryptoStatus: (ind)input should not be empty.");
        }
        return MycryptoCiphers.sm3Hash(input);
    }

    public byte[] getEncVerifyCode() {
        return this.encVerifyCode;
    }

    public byte[] getEncPayerId() {
        return this.encPayerId;
    }

    public byte[] getEncPayerName() {
        return this.encPayerName;
    }

    public byte[] getEncEInvoiceXML() {
        return this.encEInvoiceXML;
    }

    public byte[] getEncURL() {
        return this.encURL;
    }
}

