/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

public enum MyCryptoStatus {
    SUCCESS(1, "Running successful."),
    NOT_READY(-1, "The rdrand call was unsuccessful, the hardware was not ready, and a random number was not returned."),
    SUPPORTED(-2, "The rdrand instruction is supported by the host hardware."),
    UNSUPPORTED(-3, "The rdrand instruction is unsupported by the host hardware."),
    UNKNOWN(-4, "Whether or not the hardware supports the rdrand instruction is unknown."),
    NOT_LOADED(-5, "The RdRand Java Utility Native Shared Library is not loaded."),
    SM3_LENGTH_ERROR(-6, "The input length of SM3 is not 32."),
    SM4_INPUT_ERROR(-7, "SM4 encryption and decryption input params error."),
    SM4_ERROR(-16384, "SM4 Enc/Dec error."),
    SM4_ERROR_INPUT_BUFFER_SIZE(-16385, "SM4 input buffer size error."),
    SM4_ERROR_OUTPUT_BUFFER_SIZE(-16386, "SM4 output buffer size error."),
    SM4_ERROR_PADDING_CHECK_FAIL(-16387, "SM4 padding check fail."),
    SM4_ERROR_MAC_CHECK_FAIL(-16388, "SM4 mac check fail.");

    private final int code;
    private final String desc;

    private MyCryptoStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static final MyCryptoStatus getStatusByCode(int code) {
        for (MyCryptoStatus status : MyCryptoStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        return null;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getDesc() {
        return this.desc;
    }

    public static final void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }
}

