/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.logging;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.logging.JdkLoggerFactory;
import com.alipay.mychain.sdk.api.logging.Slf4JLoggerFactory;

public abstract class AbstractLoggerFactory {
    private static volatile AbstractLoggerFactory defaultFactory;

    private static AbstractLoggerFactory newDefaultFactory(String name) {
        AbstractLoggerFactory f;
        try {
            f = new Slf4JLoggerFactory(true);
            f.newInstance(name).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable ignore1) {
            f = JdkLoggerFactory.INSTANCE;
            f.newInstance(name).debug("Using java.util.logging as the default logging framework");
        }
        return f;
    }

    public static AbstractLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = AbstractLoggerFactory.newDefaultFactory(AbstractLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(AbstractLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        AbstractLoggerFactory.defaultFactory = defaultFactory;
    }

    public static ILogger getInstance(Class<?> clazz) {
        return AbstractLoggerFactory.getInstance(clazz.getName());
    }

    public static ILogger getInstance(String name) {
        return AbstractLoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract ILogger newInstance(String var1);
}

