/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.AccountService;
import com.alipay.mychain.sdk.api.service.AdminService;
import com.alipay.mychain.sdk.api.service.ConfidentialService;
import com.alipay.mychain.sdk.api.service.ContractService;
import com.alipay.mychain.sdk.api.service.EnvelopeService;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.api.service.QueryService;
import com.alipay.mychain.sdk.api.service.SpvService;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;

public class ServiceManager {
    private AccountService accountService;
    private ContractService contractService;
    private QueryService queryService;
    private AdminService adminService;
    private EventService eventService;
    private ConfidentialService confidentialService;
    private EnvelopeService envelopeService;
    private SpvService spvService;

    public ServiceManager(INetwork network, TimerTaskManager timerTaskManager, ClientEnv env) {
        this.accountService = new AccountService(network, timerTaskManager, env);
        this.contractService = new ContractService(network, timerTaskManager, env);
        this.queryService = new QueryService(network, timerTaskManager, env);
        this.adminService = new AdminService(network, timerTaskManager, env);
        this.confidentialService = new ConfidentialService(network, timerTaskManager, env);
        this.envelopeService = new EnvelopeService(network, timerTaskManager, env);
        this.spvService = new SpvService(network, timerTaskManager, env);
        this.eventService = new EventService(network, timerTaskManager, env);
    }

    public boolean startServices(MychainClient client) {
        return this.eventService.start(client) && this.spvService.start(client);
    }

    public boolean stopServices() {
        return this.eventService.stop() && this.spvService.stop();
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public ContractService getContractService() {
        return this.contractService;
    }

    public QueryService getQueryService() {
        return this.queryService;
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public ConfidentialService getConfidentialService() {
        return this.confidentialService;
    }

    public EnvelopeService getEnvelopeService() {
        return this.envelopeService;
    }

    public SpvService getSPVService() {
        return this.spvService;
    }
}

