/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.SM4CbcPkeyCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.SM2PkeyCipherV1;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM2EnvelopeV1
implements EnvelopeBase {
    private static final int SM4_128_BLOCK_SIZE = 16;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_SM2_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            SM2PkeyCipherV1 pkeyCipher = new SM2PkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new SM2PkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Random rnd = new Random();
            if (secretKey == null) {
                secretKey = new byte[16];
                rnd.nextBytes(secretKey);
            }
            SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(secretKey);
            byte[] sm4CipherText = sm4CbcPkeyCipherV1.encrypt(plaintext);
            int pubkeyNr = this.pubkeyList.size();
            int totalSize = 2;
            ArrayList<byte[]> sealSkeys = new ArrayList<byte[]>();
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] secretKeyEncrypted = publicKey.encrypt(secretKey);
                totalSize += secretKeyEncrypted.length;
                sealSkeys.add(secretKeyEncrypted);
            }
            byte[] output = new byte[totalSize += sm4CipherText.length];
            int index = 0;
            output[index++] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[index++] = (byte)(pubkeyNr & 0xFF);
            for (byte[] sealSkey : sealSkeys) {
                System.arraycopy(sealSkey, 0, output, index, sealSkey.length);
                index += sealSkey.length;
            }
            System.arraycopy(sm4CipherText, 0, output, index, sm4CipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (secretKey != null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "secret key provide by user not supported");
        }
        try {
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int index = 2;
            int sealKeyOffset = 9;
            int totalSealKeysLen = 0;
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    byte leftPartLen = cipherText[sealKeyOffset];
                    sealKeyOffset += leftPartLen + 2 + 4 + 1 + 1;
                    int totalSealKeyLen = 8 + leftPartLen;
                    totalSealKeysLen += totalSealKeyLen;
                    byte[] secretKeyEncrypted = Arrays.copyOfRange(cipherText, index, index + totalSealKeyLen);
                    index += totalSealKeyLen;
                    try {
                        if (secretKey != null) continue;
                        byte[] tempPubkey = this.privkey.decrypt(secretKeyEncrypted);
                        secretKey = tempPubkey;
                        continue;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw e;
                    }
                }
            }
            SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(secretKey);
            byte[] sm4CipherText = Arrays.copyOfRange(cipherText, 2 + totalSealKeysLen, cipherText.length);
            byte[] plainText = sm4CbcPkeyCipherV1.decrypt(sm4CipherText);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void main(String[] args) {
        ArrayList<Keypair> keypairs = new ArrayList<Keypair>();
        Keypair keypair = new Keypair(Hex.decode((String)"0003044dd20eaea90e990ff5122c7870fd1eed62598253260e31f3052c04ad287866aaa2cbc50a68d346439a61f7195c535875d4b3ff1a1382662928cf0daf36392a6e"), Hex.decode((String)"0003cfe34474818508eadc56cc55f4a4107f95fada57fd8d88d8bd065748351c1f93"));
        Keypair keypair2 = new Keypair(Hex.decode((String)"0003042a8112cde9f40ba99aa1c153a6065762960ccf04ae365f9f70a690bea2d3ca3af5465cd1fcd26f4b3875c1cd1f1d2a317627aa899013d4fcab0e94acb0fd3c68"), Hex.decode((String)"0003bda3c69580848d4c6acb9339b97d1f98a18431c663bf740c37618ef51efeeca3"));
        keypairs.add(keypair);
        keypairs.add(keypair2);
        SM2EnvelopeV1 sm2EnvelopeV1 = new SM2EnvelopeV1();
        sm2EnvelopeV1.setPubkeyList(keypairs);
        sm2EnvelopeV1.setPrivkey(keypair);
        byte[] sealed = sm2EnvelopeV1.envelopeSeal(Hex.decode((String)"48656c6c6f20776f726c6421"), null);
        System.out.println(Hex.toHexString((byte[])sealed));
        byte[] plaintext = sm2EnvelopeV1.envelopeOpen(sealed, null);
        System.out.println(new String(plaintext));
        System.out.println(new String(sm2EnvelopeV1.envelopeOpen(Hex.decode((String)"00020066cba7bbc4307902207d05d2db1d3283426d8496c87130442ca5a783ea1563ee061c73491ab0de7bbd022100d306e7991e6f5fa4f797c17ed9d0a842ddd39ee30d91977a53063fc78b45ce450420333253eeaded158b9e819820df902f4d42fb9a3a4fd23bec35cfb1644a0fbcfe0410c6ac0249c3ee0f489a3f1e9a406ca9110066166dc6c93078022029ace27dd9be04aa39c27f1add0d89bca8a0698b1f1d681d2bdee61f7b7f517a022051a70b5c210e7046026486ea245af38a4a1c926b0664b1e898547ddb7bab0dbc042043695eb6d302e263aea9267c9a3273e1c9ae50ea078667fec3942234ac98384c041049d01e8dd6059e6cb422d117cd3b8b0b00cab352d50d662243872d68a65b707235784b3b8639aa56de2b43e01cc97aaf47af"), null)));
    }
}

