/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.signer;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import sun.security.rsa.RSAPublicKeyImpl;

public class RsaSignerV1
implements SignerBase {
    private byte[] privateKey;
    private byte[] publicKey;
    private RSAPrivateCrtKey privateCrtKey;
    private RSAPublicKey rsaPublicKey;

    public RsaSignerV1(Keypair keypair) throws Exception {
        KeyFactory keyFactory;
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = pubKey;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey);
            keyFactory = KeyFactory.getInstance("RSA");
            this.rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(pubKey));
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            this.privateKey = priKey;
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKey);
            keyFactory = KeyFactory.getInstance("RSA");
            this.privateCrtKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(pkcs8KeySpec);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.rsaPublicKey = new RSAPublicKeyImpl(this.privateCrtKey.getModulus(), this.privateCrtKey.getPublicExponent());
                this.publicKey = this.rsaPublicKey.getEncoded();
            }
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.SIGNER_RSA_LOCAL_V1;
    }

    @Override
    public boolean isSigner() {
        return this.privateCrtKey != null;
    }

    @Override
    public boolean isVerifier() {
        return this.rsaPublicKey != null;
    }

    @Override
    public byte[] sign(byte[] message) {
        RSAPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(this.privateCrtKey.getModulus(), this.privateCrtKey.getPublicExponent(), this.privateCrtKey.getPrivateExponent(), this.privateCrtKey.getPrimeP(), this.privateCrtKey.getPrimeQ(), this.privateCrtKey.getPrimeExponentP(), this.privateCrtKey.getPrimeExponentQ(), this.privateCrtKey.getCrtCoefficient());
        PKCS1Encoding pkcsAlg = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        pkcsAlg.init(true, (CipherParameters)rsaPrivateCrtKeyParameters);
        try {
            byte[] rawSig = pkcsAlg.processBlock(message, 0, message.length);
            byte[] sig = new byte[6 + rawSig.length];
            System.arraycopy(this.getAlgo().toBytes(), 0, sig, 0, 2);
            byte[] withAlgoPub = new byte[this.publicKey.length + 2];
            System.arraycopy(KeyTypeEnum.KEY_RSA2048_PKCS8.toBytes(), 0, withAlgoPub, 0, 2);
            System.arraycopy(this.publicKey, 0, withAlgoPub, 2, this.publicKey.length);
            System.arraycopy(CryptoUtils.getPubkeyFp(withAlgoPub), 0, sig, 2, 4);
            System.arraycopy(rawSig, 0, sig, 6, rawSig.length);
            return sig;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public boolean verify(byte[] sigRaw, byte[] msg) {
        if (msg.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need msg size 32 but " + (ArrayUtils.isEmpty((byte[])msg) ? 0 : msg.length));
        }
        if (!this.isVerifier()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "no pub key");
        }
        if (!AlgoIdEnum.valueOf(sigRaw).equals((Object)AlgoIdEnum.SIGNER_RSA_LOCAL_V1)) {
            throw new MychainSdkException(ErrorCode.SDK_SIGN_TOOL_VERIFY_ERROR, "algo no match");
        }
        byte[] sig = new byte[sigRaw.length - 6];
        System.arraycopy(sigRaw, 6, sig, 0, sigRaw.length - 6);
        RSAKeyParameters rsaKeyParameters = new RSAKeyParameters(false, this.rsaPublicKey.getModulus(), this.rsaPublicKey.getPublicExponent());
        PKCS1Encoding pkcs1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        pkcs1Encoding.init(false, (CipherParameters)rsaKeyParameters);
        try {
            byte[] decode = pkcs1Encoding.processBlock(sig, 0, sig.length);
            return Arrays.equals(decode, msg);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void main(String[] args) throws Exception {
        Keypair keypair = new Keypair(Hex.decode((String)"000430820122300d06092a864886f70d01010105000382010f003082010a0282010100b9e24c6f2ec43437f8445d268dd9b716a3b0e7d8c08a66f1010825d43c44772d07dba3d725957c5266f1dde2d366d2884192d3a636b26010fe907bcaa268520f6d94f639082ed3921701803dff7a32e7aa05ae63458d569d41851897403f003f43037207095753da9f674856c50440ac6a26c319bc3fb53acf5929e09fcd1b52f9fa3a1aa19d4e4a2a39511f90fcb4db0bb11b2fa62331ad0c3acefec06ef4e83385d178a920e32aa9b38aec64243b8c8b16b984ba82ba5f14c6e5e2cd4c0aa5c94f9b12a8fe655d7c50d7adf27a6d9d738ca35207edf2fd3f1e52b1db0e3f05e9a3990563242e16118e06338ecd8d0f3a3da079afbdf8b95fd95fa291287edd0203010001"), Hex.decode((String)"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"));
        RsaSignerV1 rsaSignerV1 = new RsaSignerV1(keypair);
        byte[] msg = Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824");
        byte[] sig = rsaSignerV1.sign(msg);
        System.out.println(Hex.toHexString((byte[])sig));
        boolean isVerify = rsaSignerV1.verify(sig, msg);
        System.out.println(isVerify);
    }

    @Override
    public byte[] recover(byte[] sig, byte[] msg) {
        return new byte[0];
    }
}

