/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.spv.WorldStateNode;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WorldStateProof
extends MychainObject {
    private BigInteger blockNumber;
    private Hash stateRoot;
    private List<WorldStateNode> worldStateNodeList;

    public WorldStateProof(BigInteger blockNumber, Hash stateRoot, List<WorldStateNode> worldStateNodeList) {
        this.blockNumber = blockNumber;
        this.stateRoot = stateRoot;
        this.worldStateNodeList = worldStateNodeList;
    }

    public WorldStateProof() {
    }

    public Hash getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(Hash stateRoot) {
        this.stateRoot = stateRoot;
    }

    public List<WorldStateNode> getWorldStateNodeList() {
        return this.worldStateNodeList;
    }

    public void setWorldStateNodeList(List<WorldStateNode> worldStateNodeList) {
        this.worldStateNodeList = worldStateNodeList;
    }

    public void setRlpData(List<WorldStateNode> worldStateNodeList) {
        this.worldStateNodeList = worldStateNodeList;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] stateRootBytes = Rlp.encodeElement(this.stateRoot.getValue());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (WorldStateNode item : this.worldStateNodeList) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(blockNumberBytes, stateRootBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(0)).getRlpData());
        this.stateRoot = new Hash(((RlpElement)list.get(1)).getRlpData());
        this.worldStateNodeList = new ArrayList<WorldStateNode>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            WorldStateNode item = new WorldStateNode();
            item.fromRlp((RlpList)element);
            this.worldStateNodeList.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("state_root", (Object)ByteUtils.toHexString(this.stateRoot.getValue()));
        JSONArray jsonArray = new JSONArray();
        if (this.worldStateNodeList != null) {
            for (WorldStateNode item : this.worldStateNodeList) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("nodes", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.stateRoot = new Hash(jsonObject.getString("state_root"));
        this.worldStateNodeList = new ArrayList<WorldStateNode>();
        JSONArray jsonArray = jsonObject.getJSONArray("nodes");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                WorldStateNode object = new WorldStateNode();
                object.fromJson((JSONObject)iterator.next());
                this.worldStateNodeList.add(object);
            }
        }
    }
}

