/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryTransactionProofRequest
extends Request {
    private Hash hash = new Hash();

    public QueryTransactionProofRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION_PROOF);
    }

    public QueryTransactionProofRequest(Hash hash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION_PROOF);
        this.hash = hash;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.hash != null && !this.hash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue());
    }

    @Override
    public byte[] toRlp() {
        byte[] hash_data = Rlp.encodeElement(this.hash.getValue());
        return Rlp.encodeList(super.toRlp(), hash_data);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.hash = new Hash(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.hash = new Hash(jsonObject.getString("hash"));
    }
}

