/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty.handler;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.INetEventHandler;
import com.alipay.mychain.sdk.utils.SocketAddressUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MessageDuplexHandler
extends ChannelDuplexHandler {
    private INetEventHandler netEventHandler;
    private ILogger logger;

    public MessageDuplexHandler(INetEventHandler netEventHandler, ILogger logger) {
        this.netEventHandler = netEventHandler;
        this.logger = logger;
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        String localAddr = SocketAddressUtil.parseAddress(ctx.channel().localAddress());
        String remoteAddr = SocketAddressUtil.parseAddress(ctx.channel().remoteAddress());
        this.logger.debug("connect, localAddress:{}, remoteAddr:{}", (Object)localAddr, (Object)remoteAddr);
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.logger.debug("disconnect to: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.logger.debug("closed: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.close(ctx, promise);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel registered: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel unregistered: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel active: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel inactive: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String localAddress = SocketAddressUtil.parseAddress(ctx.channel().localAddress());
        String remoteAddress = SocketAddressUtil.parseAddress(ctx.channel().remoteAddress());
        this.logger.error("caught exception: local: {}, remote: {}, cause: {}\n{}", localAddress, remoteAddress, cause.getMessage(), ExceptionUtils.getStackTrace((Throwable)cause));
        if (cause instanceof DecoderException) {
            ctx.channel().close();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.netEventHandler.onMessage(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
    }
}

