/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm;

import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.vm.VMOutput;
import com.alipay.mychain.sdk.vm.abi.MyTypeDecoder;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Int;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class EVMOutput
extends VMOutput {
    private static final int MAX_N = 32;
    private static final int MIN_N = 1;
    private String rawOutput;
    private int index = 0;
    private int offset = 0;

    public EVMOutput() {
    }

    public EVMOutput(String rawOutput) {
        this.rawOutput = Numeric.cleanHexPrefix(rawOutput);
    }

    public BigInteger getInt() {
        Int value = MyTypeDecoder.decodeInt(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += 64;
        return result;
    }

    public BigInteger getUint() {
        Uint value = MyTypeDecoder.decodeUint(this.rawOutput, this.offset);
        BigInteger result = (BigInteger)value.getValue();
        this.offset += 64;
        return result;
    }

    public boolean getBoolean() {
        Bool value = MyTypeDecoder.decodeBool(this.rawOutput, this.offset);
        boolean result = (Boolean)value.getValue();
        this.offset += 64;
        return result;
    }

    public Hash getIdentity() {
        Type value = MyTypeDecoder.decodeBytes32(this.rawOutput, this.offset);
        byte[] result = (byte[])value.getValue();
        Hash hash = new Hash(result);
        this.offset += 64;
        return hash;
    }

    public String getString() {
        Utf8String value = MyTypeDecoder.decodeUtf8String(this.rawOutput, this.offset);
        String result = (String)value.getValue();
        this.offset += 64;
        return result;
    }

    public byte[] getBytes() {
        DynamicBytes value = MyTypeDecoder.decodeDynamicBytes(this.rawOutput, this.offset);
        byte[] result = (byte[])value.getValue();
        this.offset += 64;
        return result;
    }

    public byte[] getBytes32() {
        Type value = MyTypeDecoder.decodeBytes32(this.rawOutput, this.offset);
        byte[] result = (byte[])value.getValue();
        this.offset += 64;
        return result;
    }

    @Deprecated
    public byte[] getBytesN(int n) {
        if (n != 32) {
            throw new IllegalArgumentException(" n must be 32");
        }
        Type value = MyTypeDecoder.decodeBytes32(this.rawOutput, this.offset);
        byte[] result = (byte[])value.getValue();
        this.offset += 64;
        return result;
    }

    public List<byte[]> getBytes32DynamicArray() {
        Type value = MyTypeDecoder.decodeStaticArray32(this.rawOutput, this.offset);
        List values = (List)value.getValue();
        ArrayList<byte[]> bytes32Array = new ArrayList<byte[]>();
        for (Bytes32 val : values) {
            bytes32Array.add(val.getValue());
        }
        this.offset += 64;
        return bytes32Array;
    }

    public List<BigInteger> getIntDynamicArray() {
        Type value = MyTypeDecoder.decodeIntDynamicArray(this.rawOutput, this.offset);
        List values = (List)value.getValue();
        ArrayList<BigInteger> bigs = new ArrayList<BigInteger>();
        for (Int val : values) {
            bigs.add(val.getValue());
        }
        this.offset += 64;
        return bigs;
    }

    public List<BigInteger> getUintDynamicArray() {
        Type value = MyTypeDecoder.decodeUintDynamicArray(this.rawOutput, this.offset);
        List values = (List)value.getValue();
        ArrayList<BigInteger> bigs = new ArrayList<BigInteger>();
        for (Uint val : values) {
            bigs.add(val.getValue());
        }
        this.offset += 64;
        return bigs;
    }

    public List<Boolean> getBooleanDynamicArray() {
        Type value = MyTypeDecoder.decodeBoolDynamicArray(this.rawOutput, this.offset);
        List values = (List)value.getValue();
        ArrayList<Boolean> bigs = new ArrayList<Boolean>();
        for (Bool val : values) {
            bigs.add(val.getValue());
        }
        this.offset += 64;
        return bigs;
    }

    public String getRawOutput() {
        return this.rawOutput;
    }

    @Override
    public void setRawOutput(String rawOutput) {
        this.rawOutput = rawOutput;
    }
}

