/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi;

import com.alipay.mychain.sdk.vm.abi.DynamicArrayInterface;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractArray;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Int;
import com.alipay.mychain.sdk.vm.abi.datatype.StaticArray;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import com.alipay.mychain.sdk.vm.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MyTypeDecoder {
    public static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static Uint decodeUint(String rawInput, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(rawInput, offset, Uint.class);
        return MyTypeDecoder.decodeNumeric(rawInput.substring(hexStringOffset), Uint.class);
    }

    public static Int decodeInt(String rawInput, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(rawInput, offset, Int.class);
        return MyTypeDecoder.decodeNumeric(rawInput.substring(hexStringOffset), Int.class);
    }

    public static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt(input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    public static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, DynamicBytes.class);
        int encodedLength = MyTypeDecoder.decodeUintAsInt(input, hexStringOffset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = hexStringOffset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray(data);
        return new DynamicBytes(bytes);
    }

    public static Type decodeBytes32(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, Bytes32.class);
        return MyTypeDecoder.decode(input, hexStringOffset, Bytes32.class);
    }

    public static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = MyTypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static Type decodeIntDynamicArray(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, DynamicArray.class);
        return MyTypeDecoder.decodeDynamicArray(input, hexStringOffset, Int.class);
    }

    public static Type decodeUintDynamicArray(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, DynamicArray.class);
        return MyTypeDecoder.decodeDynamicArray(input, hexStringOffset, Uint.class);
    }

    public static Type decodeBoolDynamicArray(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, DynamicArray.class);
        return MyTypeDecoder.decodeDynamicArray(input, hexStringOffset, Bool.class);
    }

    public static Type decodeStaticArray32(String input, int offset) {
        int hexStringOffset = MyTypeDecoder.getDataOffset(input, offset, DynamicArray.class);
        return MyTypeDecoder.decodeDynamicArray(input, hexStringOffset, Bytes32.class);
    }

    private static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return MyTypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    private static int getTypeLengthInBytes() {
        return 32;
    }

    private static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (AbstractNumericType.class.isAssignableFrom(type)) {
            return MyTypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)MyTypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return MyTypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)MyTypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)MyTypeDecoder.decodeUtf8String(input, offset);
        }
        if (AbstractArray.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("AbstractArray types must be wrapped in a Type");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    private static <T extends AbstractNumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray(input);
            int typeLengthAsBytes = MyTypeDecoder.getTypeLengthInBytes();
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((AbstractNumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    private static <T extends Type> T decodeDynamicArray(String input, int offset, Class<T> type) {
        int length = MyTypeDecoder.decodeUintAsInt(input, offset);
        DynamicArrayInterface dynamicArrayInterface = new DynamicArrayInterface<T>(){

            @Override
            public T apply(List<T> elements, String typeName) {
                if (elements.isEmpty()) {
                    return DynamicArray.empty(typeName);
                }
                return new DynamicArray(elements);
            }
        };
        int valueOffset = offset + 64;
        return MyTypeDecoder.decodeArrayElements(input, valueOffset, type, length, dynamicArrayInterface);
    }

    private static <T extends Type> T instantiateStaticArray(Class<T> type, List<T> elements) {
        try {
            Class<List> listClass = List.class;
            return (T)((Type)type.getConstructor(listClass).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            return (T)new StaticArray<T>(elements);
        }
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, Class<T> type, int length, DynamicArrayInterface<T> dynamicArrayInterface) {
        if (AbstractArray.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Arrays of arrays are not currently supported for external functions, seehttp://solidity.readthedocs.io/en/develop/types.html#members");
        }
        ArrayList<T> elements = new ArrayList<T>(length);
        int i = 0;
        int currOffset = offset;
        while (i < length) {
            T value = MyTypeDecoder.decode(input, currOffset, type);
            elements.add(value);
            ++i;
            currOffset += MyTypeDecoder.getSingleElementLength(input, currOffset, type) * 64;
        }
        String typeName = Utils.getSimpleTypeName(type);
        return (T)((Type)dynamicArrayInterface.apply(elements, typeName));
    }

    private static <T extends Type> int getSingleElementLength(String input, int offset, Class<T> type) {
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return MyTypeDecoder.decodeUintAsInt(input, offset) / 32 + 2;
        }
        return 1;
    }

    private static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray(input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    private static <T extends Type> int getDataOffset(String input, int offset, Class<T> type) {
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type)) {
            return MyTypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }
}

