/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.annotation.privacy.ZoroType;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.exception.ZoroException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTreeBuilder.class);
    public static final String SEPARATOR = "_";

    public static Node buildObjectTree(Object obj) throws ZoroException {
        if (null == obj) {
            logger.error("Parameter (obj) is NULL.");
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        HashMap<String, Node> rootMap = new HashMap<String, Node>(32);
        ObjectTreeBuilder.buildObjectTree(obj, rootMap, "");
        Class<?> clazz = obj.getClass();
        Annotation[] classAnnotations = clazz.getAnnotations();
        return new Node("", null, classAnnotations, ZoroType.MAP, rootMap, false);
    }

    private static void buildObjectTree(Object obj, Map<String, Node> rootMap, String concreteName) {
        Field[] fields;
        if (null == obj || null == rootMap) {
            logger.error("Parameter (obj or rootMap) is NULL.");
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        Class<?> clazz = obj.getClass();
        for (Field f : fields = clazz.getDeclaredFields()) {
            Node branch;
            Node leaf;
            if (f.isSynthetic()) continue;
            f.setAccessible(true);
            Class<?> fieldType = f.getType();
            Object value = null;
            try {
                value = f.get(obj);
            }
            catch (IllegalAccessException ex) {
                logger.error("Illegal access exception: {}", (Throwable)ex);
                throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.getMessage());
            }
            Annotation[] fieldAnnotations = f.getAnnotations();
            if (fieldType == ZoroType.STRING) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.STRING, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (fieldType == ZoroType.LIST) {
                if (null == value) {
                    branch = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.LIST, null, false);
                    rootMap.put(f.getName(), branch);
                    continue;
                }
                ArrayList<Node> branchList = new ArrayList<Node>();
                String attrName = concreteName + f.getName();
                for (int i = 0; i < ((List)value).size(); ++i) {
                    Object elementOfList = ((List)value).get(i);
                    HashMap<String, Node> branchElementMap = new HashMap<String, Node>(32);
                    ObjectTreeBuilder.buildObjectTree(elementOfList, branchElementMap, attrName + SEPARATOR + i + SEPARATOR);
                    Class<?> cl = elementOfList.getClass();
                    Annotation[] classAnnotations = cl.getAnnotations();
                    Node branchNode = new Node(attrName + SEPARATOR + i + SEPARATOR, null, classAnnotations, ZoroType.MAP, branchElementMap, false);
                    branchList.add(branchNode);
                }
                Node branch2 = new Node(attrName, fieldAnnotations, null, ZoroType.LIST, branchList, false);
                rootMap.put(f.getName(), branch2);
                continue;
            }
            if (fieldType == ZoroType.PRIMITIVE_LONG) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.PRIMITIVE_LONG, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (fieldType == ZoroType.PRIMITIVE_INT) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.PRIMITIVE_INT, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (fieldType == ZoroType.PRIMITIVE_BOOLEAN) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.PRIMITIVE_BOOLEAN, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (fieldType == ZoroType.LONG) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.LONG, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (fieldType == ZoroType.MAP) {
                leaf = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.MAP, value, true);
                rootMap.put(f.getName(), leaf);
                continue;
            }
            if (null == value) {
                branch = new Node(concreteName + f.getName(), fieldAnnotations, null, ZoroType.MAP, null, false);
                rootMap.put(f.getName(), branch);
                continue;
            }
            Class<?> cl = value.getClass();
            Annotation[] classAnnotations = cl.getAnnotations();
            HashMap<String, Node> branchElementMap = new HashMap<String, Node>(32);
            ObjectTreeBuilder.buildObjectTree(value, branchElementMap, concreteName + f.getName() + SEPARATOR);
            Node branch3 = new Node(concreteName + f.getName() + SEPARATOR, fieldAnnotations, classAnnotations, ZoroType.MAP, branchElementMap, false);
            rootMap.put(f.getName(), branch3);
        }
    }
}

