/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.ApplyEnvelope;
import com.alipay.mychain.zoro.annotation.CommitmentRelation;
import com.alipay.mychain.zoro.annotation.ProofList;
import com.alipay.mychain.zoro.annotation.privacy.AnnotationHandlers;
import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.annotation.privacy.ZoroType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectTreeHandler {
    public static void processRootNode(Node rootNode) {
        HashMap<String, HashMap<String, byte[]>> envelopeEncryptionCacheMap = new HashMap<String, HashMap<String, byte[]>>(16);
        envelopeEncryptionCacheMap = ObjectTreeHandler.processTreeNode(rootNode, envelopeEncryptionCacheMap);
        AnnotationHandlers.applyEnvelopePhaseTwoHandler(rootNode, envelopeEncryptionCacheMap);
    }

    private static HashMap<String, HashMap<String, byte[]>> processTreeNode(Node treeNode, HashMap<String, HashMap<String, byte[]>> envelopeEncryptionCacheMap) {
        if (treeNode.getClassAnnotations() != null && treeNode.getClassAnnotations().length != 0) {
            ObjectTreeHandler.processClassAnnotations(treeNode);
        } else if (treeNode.getFieldAnnotations() != null && treeNode.getFieldAnnotations().length != 0) {
            envelopeEncryptionCacheMap = ObjectTreeHandler.processFieldAnnotations(treeNode, envelopeEncryptionCacheMap);
        }
        if (!treeNode.isLeaf()) {
            if (treeNode.getType().equals(ZoroType.LIST)) {
                ArrayList<Node> listNode = new ArrayList<Node>();
                List nodeList = (List)treeNode.getData();
                for (Node node : nodeList) {
                    envelopeEncryptionCacheMap = ObjectTreeHandler.processTreeNode(node, envelopeEncryptionCacheMap);
                    listNode.add(node);
                }
                treeNode.setData(listNode);
            } else {
                HashMap treeHashMap = (HashMap)treeNode.getData();
                for (String treeKey : treeHashMap.keySet()) {
                    Node tempTreeNode = (Node)treeHashMap.get(treeKey);
                    envelopeEncryptionCacheMap = ObjectTreeHandler.processTreeNode(tempTreeNode, envelopeEncryptionCacheMap);
                    treeHashMap.put(treeKey, tempTreeNode);
                }
                treeNode.setData(treeHashMap);
            }
        }
        return envelopeEncryptionCacheMap;
    }

    private static void processClassAnnotations(Node treeNode) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = treeNode.getClassAnnotations()) {
            if (!(annotation instanceof CommitmentRelation)) continue;
            AnnotationHandlers.commitmentRelationHandler(treeNode, (CommitmentRelation)annotation);
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ProofList)) continue;
            AnnotationHandlers.proofListHandler(treeNode, (ProofList)annotation);
        }
    }

    private static HashMap<String, HashMap<String, byte[]>> processFieldAnnotations(Node treeNode, HashMap<String, HashMap<String, byte[]>> envelopeEncryptionCacheMap) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = treeNode.getFieldAnnotations()) {
            if (!(annotation instanceof ApplyEnvelope)) continue;
            envelopeEncryptionCacheMap = AnnotationHandlers.applyEnvelopePhaseOneHandler(treeNode, (ApplyEnvelope)annotation, envelopeEncryptionCacheMap);
        }
        return envelopeEncryptionCacheMap;
    }
}

