/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.tools;

import com.alipay.mychain.zoro.crypto.BulletProof;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import io.netty.util.internal.NativeLibraryLoader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoroTool {
    private static final Logger logger = LoggerFactory.getLogger(ZoroTool.class);

    public static String generateBlindFactor() throws ZoroException {
        try {
            byte[] blindFactor = BulletProof.generateBlindFactor();
            return Base64Codec.encode(blindFactor);
        }
        catch (Exception ex) {
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_GENERATION_FAILED, "Failed to generate blindFactor.");
        }
    }

    public static String pedersenCommitment(String blindFactor, long value) throws ZoroException {
        if (blindFactor == null || value < 0L) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "BlindFactor is NULL or value is less than zero.");
        }
        try {
            byte[] pc = BulletProof.generateCommit(Base64Codec.decode(blindFactor), value);
            return Base64Codec.encode(pc);
        }
        catch (Exception ex) {
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_GENERATION_FAILED, "Failed to generate pedersen commitment");
        }
    }

    public static String pedersenCommitmentAdd(String firstCommitment, String secondCommitment) throws ZoroException {
        if (firstCommitment == null && secondCommitment == null) {
            return null;
        }
        if (firstCommitment == null) {
            return secondCommitment;
        }
        if (secondCommitment == null) {
            return firstCommitment;
        }
        try {
            byte[] first = Base64Codec.decode(firstCommitment);
            byte[] second = Base64Codec.decode(secondCommitment);
            ArrayList<byte[]> positiveList = new ArrayList<byte[]>();
            positiveList.add(first);
            positiveList.add(second);
            byte[] sum = BulletProof.addCommits(positiveList, null);
            return Base64Codec.encode(sum);
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to add two pedersen commitment: {}", (Throwable)ex);
                throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_ACCUMULATION_FAILED, "Failed to add two pedersen commitment");
            }
            return null;
        }
    }

    public static String pedersenCommitmentSub(String firstCommitment, String secondCommitment) throws ZoroException {
        if (firstCommitment == null && secondCommitment == null) {
            return null;
        }
        ArrayList<byte[]> positive = null;
        ArrayList<byte[]> negative = null;
        try {
            if (firstCommitment != null) {
                positive = new ArrayList<byte[]>();
                positive.add(Base64Codec.decode(firstCommitment));
            }
            if (secondCommitment != null) {
                negative = new ArrayList<byte[]>();
                negative.add(Base64Codec.decode(secondCommitment));
            }
            byte[] sum = BulletProof.addCommits(positive, negative);
            return Base64Codec.encode(sum);
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to subtract two pedersen commitment: {}", (Throwable)ex);
                throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_ACCUMULATION_FAILED, "Failed to subtract two pedersen commitment");
            }
            return null;
        }
    }

    public static boolean isTwoPedersenCommitmentEqual(String firstCommitment, String secondCommitment) throws ZoroException {
        return firstCommitment.equals(secondCommitment);
    }

    public static boolean validatePedersenCommitment(String commitment, String blindFactor, long value) {
        try {
            byte[] commit = Base64Codec.decode(commitment);
            byte[] r = Base64Codec.decode(blindFactor);
            boolean res = BulletProof.verifyCommit(commit, r, value);
            return res;
        }
        catch (Exception ex) {
            logger.error("Failed to validate pedersen commitment: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, "Failed to validate pedersen commitment");
        }
    }

    public static String blindFactorAdd(String firstBlindFactor, String secondBlindFactor) throws ZoroException {
        if (firstBlindFactor == null && secondBlindFactor == null) {
            return null;
        }
        if (firstBlindFactor == null) {
            return secondBlindFactor;
        }
        if (secondBlindFactor == null) {
            return firstBlindFactor;
        }
        try {
            ArrayList<byte[]> positiveList = new ArrayList<byte[]>();
            positiveList.add(Base64Codec.decode(firstBlindFactor));
            positiveList.add(Base64Codec.decode(secondBlindFactor));
            byte[] res = BulletProof.addBlindFactors(positiveList, null);
            return Base64Codec.encode(res);
        }
        catch (Exception ex) {
            logger.error("Failed to add two blind factor: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_ADDITION_FAILED, "Failed to add two blind factor");
        }
    }

    public static String blindFactorSub(String firstBlindFactor, String secondBlindFactor) throws ZoroException {
        if (firstBlindFactor == null && secondBlindFactor == null) {
            return null;
        }
        ArrayList<byte[]> positive = null;
        ArrayList<byte[]> negative = null;
        try {
            if (firstBlindFactor != null) {
                positive = new ArrayList<byte[]>();
                positive.add(Base64Codec.decode(firstBlindFactor));
            }
            if (secondBlindFactor != null) {
                negative = new ArrayList<byte[]>();
                negative.add(Base64Codec.decode(secondBlindFactor));
            }
            byte[] res = BulletProof.addBlindFactors(positive, negative);
            return Base64Codec.encode(res);
        }
        catch (Exception ex) {
            logger.error("Failed to subtract two blind factor: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_SUBTRACTION_FAILED, "Failed to subtract two blind factor");
        }
    }

    public static String generateProof(String blindFactor, long value) throws ZoroException {
        if (blindFactor == null || value < 0L) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "BlindFactor is NULL or value is less than zero.");
        }
        try {
            byte[] proof = BulletProof.generateProof(Base64Codec.decode(blindFactor), value);
            return Base64Codec.encode(proof);
        }
        catch (Exception ex) {
            throw new ZoroException(ZoroErrorCodeEnum.PROOF_GENERATION_FAILED, "Failed to generate proof.");
        }
    }

    public static String generateProof(String[] blindFactors, long[] values) throws ZoroException {
        if (blindFactors == null || values == null) {
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "BlindFactor and values should not be NULL.");
        }
        for (long v : values) {
            if (v >= 0L) continue;
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "value should be greater than zero.");
        }
        try {
            ArrayList<byte[]> blindList = new ArrayList<byte[]>();
            for (String blind : blindFactors) {
                blindList.add(Base64Codec.decode(blind));
            }
            byte[] proof = BulletProof.generateProof(blindList, values);
            return Base64Codec.encode(proof);
        }
        catch (Exception ex) {
            throw new ZoroException(ZoroErrorCodeEnum.PROOF_GENERATION_FAILED, "Failed to generate proof.");
        }
    }

    public static boolean verifyProof(String proof, String[] commitments) throws ZoroException {
        try {
            byte[] proofInBytes = Base64Codec.decode(proof);
            ArrayList<byte[]> commitList = new ArrayList<byte[]>();
            for (String commit : commitments) {
                commitList.add(Base64Codec.decode(commit));
            }
            boolean res = BulletProof.verifyProof(proofInBytes, commitList);
            return res;
        }
        catch (Exception ex) {
            logger.error("Failed to verify proof: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.PROOF_VERIFY_FAILED, "Failed to verify proof");
        }
    }

    static {
        try {
            NativeLibraryLoader.loadFirstAvailable((ClassLoader)ZoroTool.class.getClassLoader(), (String[])new String[]{"bulletproof_m_jni"});
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to load java native library: {}", (Throwable)ex);
            }
            throw new ZoroException(ZoroErrorCodeEnum.LOAD_JNI_LIBRARY_EXCEPTION, "Failed to load java native library");
        }
    }
}

