/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg.processor.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Map;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessException;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageProcessorReflectionDelegate
implements ImageProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Object compressor;
    private Method isUsable;
    private Method compressGeneral;
    private Method compressJpeg;
    private Method decompressGeneral;
    private Method decompressJpeg;
    protected boolean usable = true;

    public ImageProcessorReflectionDelegate(String implClassName) {
        try {
            Class<?> clazz = Class.forName(implClassName);
            this.compressor = clazz.newInstance();
            this.isUsable = clazz.getDeclaredMethod("isUsable", new Class[0]);
            this.compressGeneral = clazz.getDeclaredMethod("compressGeneralImage", BufferedImage.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.compressJpeg = clazz.getDeclaredMethod("compressJpegImage", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.decompressGeneral = clazz.getDeclaredMethod("decompressGeneralImage", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.decompressJpeg = clazz.getDeclaredMethod("decompressJpegImage", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            this.log.error("Couldn't not create instance of org.libjpegturbo.turbojpeg.processor.impl.ImageProcessorImpl", (Throwable)e);
            this.setUnusable();
        }
    }

    public ImageProcessorReflectionDelegate() {
        this("org.libjpegturbo.turbojpeg.processor.impl.ImageProcessorImpl");
    }

    protected void setUnusable() {
        this.usable = false;
        this.compressor = null;
        this.isUsable = null;
        this.compressGeneral = null;
        this.compressJpeg = null;
        this.decompressGeneral = null;
        this.decompressJpeg = null;
    }

    @Override
    public boolean isUsable() {
        try {
            if (this.compressor != null && this.isUsable != null) {
                Object result = this.isUsable.invoke(this.compressor, new Object[0]);
                return result instanceof Boolean && (Boolean)result == true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public ByteArrayInputStream compressGeneralImage(BufferedImage inImage, int quality, int subsampling, int flags) throws ImageProcessException {
        try {
            return (ByteArrayInputStream)this.compressGeneral.invoke(this.compressor, inImage, quality, subsampling, flags);
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    @Override
    public ByteArrayInputStream compressJpegImage(byte[] inImage, int width, int height, int quality, int subsampling, int flags) throws ImageProcessException {
        try {
            return (ByteArrayInputStream)this.compressJpeg.invoke(this.compressor, inImage, width, height, quality, subsampling, flags);
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    @Override
    public BufferedImage decompressGeneralImage(byte[] inImage, int numerator, int denominator, int flags) throws ImageProcessException {
        try {
            return (BufferedImage)this.decompressGeneral.invoke(this.compressor, inImage, numerator, denominator, flags);
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    @Override
    public Map<String, Object> decompressJpegImage(byte[] inImage, int numerator, int denominator, int flags) throws ImageProcessException {
        try {
            return (Map)this.decompressJpeg.invoke(this.compressor, inImage, numerator, denominator, flags);
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }
}

